/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.swing;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import org.ladsn.tool.core.exceptions.UtilException;
import org.ladsn.tool.core.swing.ScreenUtil;
import org.ladsn.tool.core.util.ImageUtil;

public class RobotUtil {
    public static final Robot robot;

    public static BufferedImage captureScreen() {
        return RobotUtil.captureScreen(ScreenUtil.getRectangle());
    }

    public static File captureScreen(File outFile) {
        ImageUtil.write(RobotUtil.captureScreen(), outFile);
        return outFile;
    }

    public static BufferedImage captureScreen(Rectangle screenRect) {
        return robot.createScreenCapture(screenRect);
    }

    public static File captureScreen(Rectangle screenRect, File outFile) {
        ImageUtil.write(RobotUtil.captureScreen(screenRect), outFile);
        return outFile;
    }

    static {
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            throw new UtilException(e);
        }
    }
}

