/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.text.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ladsn.tool.core.io.FileUtil;
import org.ladsn.tool.core.io.IORuntimeException;
import org.ladsn.tool.core.lang.Assert;
import org.ladsn.tool.core.text.csv.CsvData;
import org.ladsn.tool.core.text.csv.CsvParser;
import org.ladsn.tool.core.text.csv.CsvReadConfig;
import org.ladsn.tool.core.text.csv.CsvRow;
import org.ladsn.tool.core.util.CharsetUtil;
import org.ladsn.tool.core.util.ObjectUtil;

public final class CsvReader {
    CsvReadConfig config;

    public CsvReader() {
        this(null);
    }

    public CsvReader(CsvReadConfig config) {
        this.config = ObjectUtil.defaultIfNull(config, CsvReadConfig.defaultConfig());
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws IORuntimeException {
        return this.read(file, CharsetUtil.CHARSET_UTF_8);
    }

    public CsvData read(File file, Charset charset) throws IORuntimeException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) throws IORuntimeException {
        return this.read(path, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CsvData read(Path path, Charset charset) throws IORuntimeException {
        Assert.notNull(path, "path must not be null", new Object[0]);
        try (BufferedReader reader = FileUtil.getReader(path, charset);){
            CsvData csvData = this.read(reader);
            return csvData;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public CsvData read(Reader reader) throws IORuntimeException {
        CsvRow csvRow;
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        while ((csvRow = csvParser.nextRow()) != null) {
            rows.add(csvRow);
        }
        List<String> header = this.config.containsHeader ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    private CsvParser parse(Reader reader) throws IORuntimeException {
        return new CsvParser(reader, this.config);
    }
}

