/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.text.replacer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ladsn.tool.core.text.StrBuilder;
import org.ladsn.tool.core.text.replacer.StrReplacer;

public class LookupReplacer
extends StrReplacer {
    private final Map<String, String> lookupMap = new HashMap<String, String>();
    private final Set<Character> prefixSet = new HashSet<Character>();
    private final int minLength;
    private final int maxLength;

    public LookupReplacer(String[] ... lookup) {
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        for (String[] pair : lookup) {
            String key = pair[0];
            this.lookupMap.put(key, pair[1]);
            this.prefixSet.add(Character.valueOf(key.charAt(0)));
            int keySize = key.length();
            if (keySize > maxLength) {
                maxLength = keySize;
            }
            if (keySize >= minLength) continue;
            minLength = keySize;
        }
        this.maxLength = maxLength;
        this.minLength = minLength;
    }

    @Override
    protected int replace(CharSequence str, int pos, StrBuilder out) {
        if (this.prefixSet.contains(Character.valueOf(str.charAt(pos)))) {
            int max = this.maxLength;
            if (pos + this.maxLength > str.length()) {
                max = str.length() - pos;
            }
            for (int i = max; i >= this.minLength; --i) {
                CharSequence subSeq = str.subSequence(pos, pos + i);
                String result = this.lookupMap.get(subSeq.toString());
                if (null == result) continue;
                out.append(result);
                return i;
            }
        }
        return 0;
    }
}

