/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.ladsn.tool.core.thread.ThreadUtil;
import org.ladsn.tool.core.util.StrUtil;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final boolean isDeamon;
    private final Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String prefix, boolean isDeamon) {
        this(prefix, null, isDeamon);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDeamon) {
        this(prefix, threadGroup, isDeamon, null);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDeamon, Thread.UncaughtExceptionHandler handler) {
        String string = this.prefix = StrUtil.isBlank(prefix) ? "Hutool" : prefix;
        if (null == threadGroup) {
            threadGroup = ThreadUtil.currentThreadGroup();
        }
        this.group = threadGroup;
        this.isDeamon = isDeamon;
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, StrUtil.format((CharSequence)"{}{}", this.prefix, this.threadNumber.getAndIncrement()));
        if (!t.isDaemon()) {
            if (this.isDeamon) {
                t.setDaemon(true);
            }
        } else if (!this.isDeamon) {
            t.setDaemon(false);
        }
        if (null != this.handler) {
            t.setUncaughtExceptionHandler(this.handler);
        }
        if (5 != t.getPriority()) {
            t.setPriority(5);
        }
        return t;
    }
}

