/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.util;

import org.ladsn.tool.core.text.escape.Html4Escape;
import org.ladsn.tool.core.text.escape.Html4Unescape;
import org.ladsn.tool.core.util.StrUtil;

public class EscapeUtil {
    public static String escapeHtml4(String html) {
        Html4Escape escape = new Html4Escape();
        return escape.replace(html).toString();
    }

    public static String unescapeHtml4(String html) {
        Html4Unescape unescape = new Html4Unescape();
        return unescape.replace(html).toString();
    }

    public static String escape(String content) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(content.length() * 6);
        for (int i = 0; i < content.length(); ++i) {
            char j = content.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String content) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        StringBuilder tmp = new StringBuilder(content.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < content.length()) {
            pos = content.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (content.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(content.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(content.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(content.substring(lastPos));
                lastPos = content.length();
                continue;
            }
            tmp.append(content.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String safeUnescape(String content) {
        try {
            return EscapeUtil.unescape(content);
        }
        catch (Exception exception) {
            return content;
        }
    }
}

