/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.json;

import org.ladsn.tool.core.convert.ConvertException;
import org.ladsn.tool.core.getter.OptNullBasicTypeFromObjectGetter;
import org.ladsn.tool.json.InternalJSONUtil;
import org.ladsn.tool.json.JSONArray;
import org.ladsn.tool.json.JSONObject;
import org.ladsn.tool.json.JSONUtil;

public abstract class JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public String getStr(K key, String defaultValue) {
        String str = super.getStr(key, defaultValue);
        if (null == str) {
            return defaultValue;
        }
        return JSONUtil.escape(str);
    }

    public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return new JSONArray(object);
    }

    public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return new JSONObject(object);
    }

    public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return (T)(null == obj ? null : obj.toBean(beanType));
    }

    public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return (T)InternalJSONUtil.jsonConvert(type, value, ignoreError);
    }
}

