/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.poi.excel;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.ladsn.tool.core.bean.BeanUtil;
import org.ladsn.tool.core.collection.CollUtil;
import org.ladsn.tool.core.collection.IterUtil;
import org.ladsn.tool.core.io.FileUtil;
import org.ladsn.tool.core.lang.Assert;
import org.ladsn.tool.core.map.MapUtil;
import org.ladsn.tool.core.util.ObjectUtil;
import org.ladsn.tool.core.util.StrUtil;
import org.ladsn.tool.poi.excel.ExcelBase;
import org.ladsn.tool.poi.excel.ExcelWriter;
import org.ladsn.tool.poi.excel.RowUtil;
import org.ladsn.tool.poi.excel.WorkbookUtil;
import org.ladsn.tool.poi.excel.cell.CellEditor;
import org.ladsn.tool.poi.excel.cell.CellUtil;

public class ExcelReader
extends ExcelBase<ExcelReader> {
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;
    private Map<String, String> headerAlias = new HashMap<String, String>();

    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileUtil.file((String)excelFilePath), sheetIndex);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorkbookUtil.createBook(bookFile), sheetIndex);
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(WorkbookUtil.createBook(bookFile), sheetName);
    }

    public ExcelReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        this(WorkbookUtil.createBook(bookStream, closeAfterRead), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        this(WorkbookUtil.createBook(bookStream, closeAfterRead), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(book.getSheetAt(sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(book.getSheet(sheetName));
    }

    public ExcelReader(Sheet sheet) {
        super(sheet);
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
        return this;
    }

    public ExcelReader setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    public Map<String, String> getHeaderAlias() {
        return this.headerAlias;
    }

    public ExcelReader setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelReader addHeaderAlias(String header, String alias) {
        this.headerAlias.put(header, alias);
        return this;
    }

    public ExcelReader removeHeaderAlias(String header) {
        this.headerAlias.remove(header);
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        boolean isFirstLine = true;
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList = this.readRow(i);
            if (!CollUtil.isNotEmpty(rowList) && this.ignoreEmptyRow) continue;
            if (null == rowList) {
                rowList = new ArrayList<Object>(0);
            }
            if (isFirstLine) {
                isFirstLine = false;
                if (MapUtil.isNotEmpty(this.headerAlias)) {
                    rowList = this.aliasHeader(rowList);
                }
            }
            resultList.add(rowList);
        }
        return resultList;
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        int firstRowNum = this.sheet.getFirstRowNum();
        int lastRowNum = this.sheet.getLastRowNum();
        if (headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is lower than first row index {}.", (Object[])new Object[]{headerRowIndex, firstRowNum}));
        }
        if (headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is greater than last row index {}.", (Object[])new Object[]{headerRowIndex, firstRowNum}));
        }
        startRowIndex = Math.max(startRowIndex, firstRowNum);
        endRowIndex = Math.min(endRowIndex, lastRowNum);
        List<Object> headerList = this.readRow(this.sheet.getRow(headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == headerRowIndex || !CollUtil.isNotEmpty(rowList = this.readRow(this.sheet.getRow(i))) && this.ignoreEmptyRow) continue;
            if (null == rowList) {
                rowList = new ArrayList<Object>(0);
            }
            result.add(IterUtil.toMap(this.aliasHeader(headerList), rowList, (boolean)true));
        }
        return result;
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        this.checkNotClosed();
        List<Map<String, Object>> mapList = this.read(headerRowIndex, startRowIndex, endRowIndex);
        if (Map.class.isAssignableFrom(beanType)) {
            return mapList;
        }
        ArrayList<Object> beanList = new ArrayList<Object>(mapList.size());
        for (Map<String, Object> map : mapList) {
            beanList.add(BeanUtil.mapToBean(map, beanType, (boolean)false));
        }
        return beanList;
    }

    public String readAsText(boolean withSheetName) {
        ExcelExtractor extractor = this.getExtractor();
        extractor.setIncludeSheetNames(withSheetName);
        return extractor.getText();
    }

    public ExcelExtractor getExtractor() {
        Workbook wb = this.workbook;
        Object extractor = wb instanceof HSSFWorkbook ? new org.apache.poi.hssf.extractor.ExcelExtractor((HSSFWorkbook)wb) : new XSSFExcelExtractor((XSSFWorkbook)wb);
        return extractor;
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return CellUtil.getCellValue(this.getCell(x, y), this.cellEditor);
    }

    public ExcelWriter getWriter() {
        return new ExcelWriter(this.sheet);
    }

    private List<Object> readRow(Row row) {
        return RowUtil.readRow(row, this.cellEditor);
    }

    private List<String> aliasHeader(List<Object> headerList) {
        ArrayList<String> result = new ArrayList<String>();
        if (CollUtil.isEmpty(headerList)) {
            return result;
        }
        String alias = null;
        for (Object headerObj : headerList) {
            if (null != headerObj) {
                String header = headerObj.toString();
                alias = (String)ObjectUtil.defaultIfNull((Object)this.headerAlias.get(header), (Object)header);
            }
            result.add(alias);
        }
        return result;
    }

    private void checkNotClosed() {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelReader has been closed!", (Object[])new Object[0]);
    }
}

