/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.poi.excel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.ladsn.tool.core.io.FileUtil;
import org.ladsn.tool.core.io.IORuntimeException;
import org.ladsn.tool.core.io.IoUtil;
import org.ladsn.tool.core.util.StrUtil;
import org.ladsn.tool.poi.PoiChecker;
import org.ladsn.tool.poi.excel.BigExcelWriter;
import org.ladsn.tool.poi.excel.ExcelReader;
import org.ladsn.tool.poi.excel.ExcelWriter;
import org.ladsn.tool.poi.excel.sax.Excel03SaxReader;
import org.ladsn.tool.poi.excel.sax.Excel07SaxReader;
import org.ladsn.tool.poi.excel.sax.handler.RowHandler;

public class ExcelUtil {
    public static void readBySax(String path, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream((String)path), sheetIndex, rowHandler);
    }

    public static void readBySax(File file, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream((File)file), sheetIndex, rowHandler);
    }

    public static void readBySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        if (ExcelUtil.isXlsx(in = IoUtil.toMarkSupportStream((InputStream)in))) {
            ExcelUtil.read07BySax(in, sheetIndex, rowHandler);
        } else {
            ExcelUtil.read03BySax(in, sheetIndex, rowHandler);
        }
    }

    public static Excel07SaxReader read07BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel07SaxReader(rowHandler).read(in, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel07SaxReader read07BySax(File file, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel07SaxReader(rowHandler).read(file, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel07SaxReader read07BySax(String path, int sheetIndex, RowHandler rowHandler) {
        try {
            return (Excel07SaxReader)new Excel07SaxReader(rowHandler).read(path, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel03SaxReader read03BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel03SaxReader(rowHandler).read(in, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel03SaxReader read03BySax(File file, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel03SaxReader(rowHandler).read(file, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel03SaxReader read03BySax(String path, int sheetIndex, RowHandler rowHandler) {
        try {
            return (Excel03SaxReader)new Excel03SaxReader(rowHandler).read(path, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(String bookFilePath) {
        return ExcelUtil.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelUtil.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        try {
            return new ExcelReader(bookFilePath, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        try {
            return new ExcelReader(bookFile, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        try {
            return new ExcelReader(bookFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelUtil.getReader(bookStream, 0, true);
    }

    public static ExcelReader getReader(InputStream bookStream, boolean closeAfterRead) {
        try {
            return ExcelUtil.getReader(bookStream, 0, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        try {
            return new ExcelReader(bookStream, sheetIndex, true);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetIndex, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        try {
            return new ExcelReader(bookStream, sheetName, true);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetName, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter() {
        try {
            return new ExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        try {
            return new ExcelWriter(isXlsx);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(String destFilePath) {
        try {
            return new ExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(File destFile) {
        try {
            return new ExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(String destFilePath, String sheetName) {
        try {
            return new ExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(File destFile, String sheetName) {
        try {
            return new ExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getBigWriter() {
        try {
            return new BigExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getBigWriter(int rowAccessWindowSize) {
        try {
            return new BigExcelWriter(rowAccessWindowSize);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath) {
        try {
            return new BigExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static BigExcelWriter getBigWriter(File destFile) {
        try {
            return new BigExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath, String sheetName) {
        try {
            return new BigExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static BigExcelWriter getBigWriter(File destFile, String sheetName) {
        try {
            return new BigExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static boolean isXls(InputStream in) {
        PushbackInputStream pin = IoUtil.toPushbackStream((InputStream)in, (int)8);
        try {
            return FileMagic.valueOf((InputStream)pin) == FileMagic.OLE2;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static boolean isXlsx(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try {
            return FileMagic.valueOf((InputStream)in) == FileMagic.OOXML;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        if (null == book) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName = StrUtil.isBlank((CharSequence)sheetName) ? "sheet1" : sheetName);
        if (null == sheet) {
            sheet = book.createSheet(sheetName);
        }
        return sheet;
    }

    public static boolean isEmpty(Sheet sheet) {
        return null == sheet || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0;
    }
}

