/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.poi.excel;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.ladsn.tool.core.bean.BeanUtil;
import org.ladsn.tool.core.collection.CollUtil;
import org.ladsn.tool.core.comparator.IndexedComparator;
import org.ladsn.tool.core.io.FileUtil;
import org.ladsn.tool.core.io.IORuntimeException;
import org.ladsn.tool.core.io.IoUtil;
import org.ladsn.tool.core.lang.Assert;
import org.ladsn.tool.core.map.MapUtil;
import org.ladsn.tool.core.util.StrUtil;
import org.ladsn.tool.poi.excel.ExcelBase;
import org.ladsn.tool.poi.excel.ExcelUtil;
import org.ladsn.tool.poi.excel.RowUtil;
import org.ladsn.tool.poi.excel.StyleSet;
import org.ladsn.tool.poi.excel.WorkbookUtil;
import org.ladsn.tool.poi.excel.cell.CellUtil;
import org.ladsn.tool.poi.excel.style.Align;

public class ExcelWriter
extends ExcelBase<ExcelWriter> {
    protected File destFile;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private Map<String, String> headerAlias;
    private Comparator<String> aliasComparator;
    private StyleSet styleSet = new StyleSet(this.workbook);

    public ExcelWriter() {
        this(false);
    }

    public ExcelWriter(boolean isXlsx) {
        this(WorkbookUtil.createBook(isXlsx), null);
    }

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(WorkbookUtil.createBook(isXlsx), sheetName);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileUtil.file((String)destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? WorkbookUtil.createBook(FileUtil.getInputStream((File)destFile), true) : WorkbookUtil.createBook(StrUtil.endWithIgnoreCase((CharSequence)destFile.getName(), (CharSequence)".xlsx")), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this(ExcelUtil.getOrCreateSheet(workbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        this.resetRow();
        return (ExcelWriter)super.setSheet(sheetIndex);
    }

    @Override
    public ExcelWriter setSheet(String sheetName) {
        this.resetRow();
        return (ExcelWriter)super.setSheet(sheetName);
    }

    public ExcelWriter renameSheet(String sheetName) {
        return this.renameSheet(this.workbook.getSheetIndex(this.sheet), sheetName);
    }

    public ExcelWriter renameSheet(int sheet, String sheetName) {
        this.workbook.setSheetName(sheet, sheetName);
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex) {
        this.sheet.autoSizeColumn(columnIndex);
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        return this;
    }

    public ExcelWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public CellStyle getHeadCellStyle() {
        return this.styleSet.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.styleSet.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelWriter addHeaderAlias(String name, String alias) {
        Map<String, String> headerAlias = this.headerAlias;
        if (null == headerAlias) {
            headerAlias = new LinkedHashMap<String, String>();
        }
        this.headerAlias = headerAlias;
        headerAlias.put(name, alias);
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setRowHeight(int rownum, int height) {
        if (rownum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            this.sheet.getRow(rownum).setHeightInPoints((float)height);
        }
        return this;
    }

    public ExcelWriter setHeaderOrFooter(String text, Align align, boolean isFooter) {
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (align) {
            case LEFT: {
                headerFooter.setLeft(text);
                break;
            }
            case RIGHT: {
                headerFooter.setRight(text);
                break;
            }
            case CENTER: {
                headerFooter.setCenter(text);
                break;
            }
        }
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        return this.merge(lastColumn, content, true);
    }

    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        int rowIndex = this.currentRow.get();
        this.merge(rowIndex, rowIndex, 0, lastColumn, content, isSetHeaderStyle);
        if (null != content) {
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter merge(int firstRow, int lastRow, int firstColumn, int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        CellStyle style = isSetHeaderStyle && null != this.styleSet && null != this.styleSet.headCellStyle ? this.styleSet.headCellStyle : this.styleSet.cellStyle;
        CellUtil.mergingCells(this.sheet, firstRow, lastRow, firstColumn, lastColumn, style);
        if (null != content) {
            Cell cell = this.getOrCreateCell(firstColumn, firstRow);
            CellUtil.setCellValue(cell, content, this.styleSet, isSetHeaderStyle);
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        int index = 0;
        for (Object object : data) {
            this.writeRow(object, 0 == index);
            ++index;
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        boolean isFirstRow = true;
        for (Object obj : data) {
            Map map;
            if (obj instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)obj);
            } else {
                map = BeanUtil.beanToMap(obj, new TreeMap(comparator), (boolean)false, (boolean)false);
            }
            this.writeRow(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        RowUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, true);
        return this;
    }

    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        if (rowBean instanceof Iterable) {
            return this.writeRow((Iterable)rowBean);
        }
        Map rowMap = null;
        if (rowBean instanceof Map) {
            rowMap = (Map)rowBean;
        } else if (BeanUtil.isBean(rowBean.getClass())) {
            rowMap = MapUtil.isEmpty(this.headerAlias) ? BeanUtil.beanToMap((Object)rowBean, new LinkedHashMap(), (boolean)false, (boolean)false) : BeanUtil.beanToMap((Object)rowBean, new TreeMap(this.getInitedAliasComparator()), (boolean)false, (boolean)false);
        } else {
            return this.writeRow(CollUtil.newArrayList((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public ExcelWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        if (MapUtil.isEmpty(rowMap)) {
            return this.passCurrentRow();
        }
        if (isWriteKeyAsHead) {
            this.writeHeadRow(this.aliasHeader(rowMap.keySet()));
        }
        this.writeRow(rowMap.values());
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        RowUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, false);
        return this;
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        Cell cell = this.getOrCreateCell(x, y);
        CellUtil.setCellValue(cell, value, this.styleSet, false);
        return this;
    }

    @Deprecated
    public CellStyle createStyleForCell(int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        CellStyle cellStyle = this.workbook.createCellStyle();
        cell.setCellStyle(cellStyle);
        return cellStyle;
    }

    public Font createFont() {
        return this.getWorkbook().createFont();
    }

    public ExcelWriter flush() throws IORuntimeException {
        return this.flush(this.destFile);
    }

    public ExcelWriter flush(File destFile) throws IORuntimeException {
        Assert.notNull((Object)destFile, (String)"[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", (Object[])new Object[0]);
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream((File)destFile);
            this.flush(out);
        }
        finally {
            IoUtil.close((Closeable)out);
        }
        return this;
    }

    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        try {
            this.workbook.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.currentRow = null;
        this.styleSet = null;
    }

    private Collection<?> aliasHeader(Collection<?> keys) {
        if (MapUtil.isEmpty(this.headerAlias)) {
            return keys;
        }
        ArrayList alias = new ArrayList();
        for (Object key : keys) {
            String aliasName = this.headerAlias.get(key);
            alias.add(null == aliasName ? key : aliasName);
        }
        return alias;
    }

    private Comparator<String> getInitedAliasComparator() {
        if (MapUtil.isEmpty(this.headerAlias)) {
            return null;
        }
        IndexedComparator aliasComparator = this.aliasComparator;
        if (null == aliasComparator) {
            Set<String> keySet = this.headerAlias.keySet();
            this.aliasComparator = aliasComparator = new IndexedComparator((Object[])keySet.toArray(new String[keySet.size()]));
        }
        return aliasComparator;
    }
}

