/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.poi.excel;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.ladsn.tool.core.io.FileUtil;
import org.ladsn.tool.core.io.IORuntimeException;
import org.ladsn.tool.core.io.IoUtil;
import org.ladsn.tool.poi.exceptions.POIException;

public class WorkbookUtil {
    public static Workbook createBook(String excelFilePath) {
        return WorkbookUtil.createBook(FileUtil.file((String)excelFilePath), null);
    }

    public static Workbook createBook(File excelFile) {
        return WorkbookUtil.createBook(excelFile, null);
    }

    public static Workbook createBook(File excelFile, String password) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook createBook(InputStream in, boolean closeAfterRead) {
        return WorkbookUtil.createBook(in, null, closeAfterRead);
    }

    public static Workbook createBook(InputStream in, String password, boolean closeAfterRead) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)IoUtil.toMarkSupportStream((InputStream)in), (String)password);
            return workbook;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            if (closeAfterRead) {
                IoUtil.close((Closeable)in);
            }
        }
    }

    public static Workbook createBook(boolean isXlsx) {
        Object workbook = isXlsx ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath) {
        return WorkbookUtil.createSXSSFBook(FileUtil.file((String)excelFilePath), null);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile) {
        return WorkbookUtil.createSXSSFBook(excelFile, null);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password) {
        return WorkbookUtil.toSXSSFBook(WorkbookUtil.createBook(excelFile, password));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, boolean closeAfterRead) {
        return WorkbookUtil.createSXSSFBook(in, null, closeAfterRead);
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password, boolean closeAfterRead) {
        return WorkbookUtil.toSXSSFBook(WorkbookUtil.createBook(in, password, closeAfterRead));
    }

    public static SXSSFWorkbook createSXSSFBook() {
        return new SXSSFWorkbook();
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize) {
        return new SXSSFWorkbook(rowAccessWindowSize);
    }

    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    private static SXSSFWorkbook toSXSSFBook(Workbook book) {
        if (book instanceof SXSSFWorkbook) {
            return (SXSSFWorkbook)book;
        }
        if (book instanceof XSSFWorkbook) {
            return new SXSSFWorkbook((XSSFWorkbook)book);
        }
        throw new POIException("The input is not a [xlsx] format.");
    }
}

