/*
 * Decompiled with CFR 0.152.
 */
package org.lambico.test.spring.hibernate;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lambico.dao.generic.Dao;
import org.lambico.dao.generic.GenericDao;
import org.lambico.dao.generic.GenericDaoBase;
import org.lambico.dao.generic.GenericDaoTypeSupport;
import org.lambico.dao.spring.BusinessDao;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;

public final class DaoUtils {
    private static Logger logger = Logger.getLogger(DaoUtils.class);

    private DaoUtils() {
    }

    public static Map<String, Object> getDaos(ListableBeanFactory beanFactory) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            try {
                Object bean = beanFactory.getBean(beanNames[i]);
                if (!DaoUtils.isDao(bean)) continue;
                result.put(beanNames[i], bean);
                continue;
            }
            catch (BeanIsAbstractException ex) {
                logger.debug((Object)"The requested bean is abstract.");
            }
        }
        return result;
    }

    public static boolean isDao(Object o) {
        if (AnnotationUtils.findAnnotation(o.getClass(), BusinessDao.class) != null) {
            return true;
        }
        Class<?>[] objInterfaces = o.getClass().getInterfaces();
        for (int i = 0; i < objInterfaces.length; ++i) {
            if (objInterfaces[i].getAnnotation(Dao.class) == null) continue;
            return true;
        }
        return GenericDao.class.isAssignableFrom(o.getClass());
    }

    public static boolean isDaoFor(Object o, Class daoEntityType) {
        if (AnnotationUtils.findAnnotation(o.getClass(), BusinessDao.class) != null && ((GenericDaoTypeSupport)o).getType().getName().equals(daoEntityType.getName())) {
            return true;
        }
        Class<?>[] objInterfaces = o.getClass().getInterfaces();
        for (int i = 0; i < objInterfaces.length; ++i) {
            Dao daoAnnotation = objInterfaces[i].getAnnotation(Dao.class);
            if (daoAnnotation == null || !daoAnnotation.entity().getName().equals(daoEntityType.getName())) continue;
            return true;
        }
        return GenericDaoTypeSupport.class.isAssignableFrom(o.getClass()) && ((GenericDaoTypeSupport)o).getType().equals(daoEntityType);
    }

    public static GenericDaoBase getDaoFor(Class daoEntityType, ListableBeanFactory beanFactory) {
        GenericDaoBase result = null;
        Map<String, Object> daos = DaoUtils.getDaos(beanFactory);
        for (Object dao : daos.values()) {
            if (!DaoUtils.isDaoFor(dao, daoEntityType)) continue;
            result = (GenericDaoBase)dao;
            break;
        }
        return result;
    }
}

