/*
 * Decompiled with CFR 0.152.
 */
package org.lambico.test.spring;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class);
    private static final byte[] UTF8_PREAMBLE = new byte[]{-17, -69, -65};
    private static final String UTF8_UNICODE_PREAMBLE = "\ufeff";

    protected Utils() {
    }

    public static List<String> convertToNameValueList(Map map) {
        return Utils.convertToNameValueList(map, false);
    }

    public static List<String> convertToNameValueList(Map map, boolean urlEncode) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : map.keySet()) {
            Object tmp = map.get(key);
            if (tmp instanceof String[]) {
                String[] values;
                for (String value : values = (String[])tmp) {
                    if (urlEncode) {
                        try {
                            result.add(key + "=" + URLEncoder.encode(value, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException ex) {
                            logger.warn((Object)"Your OS doesn't support UTF-8, so we can encode", (Throwable)ex);
                            result.add(key + "=" + value);
                        }
                        continue;
                    }
                    result.add(key + "=" + value);
                }
                continue;
            }
            if (!(tmp instanceof String)) continue;
            String value = (String)tmp;
            if (urlEncode) {
                try {
                    result.add(key + "=" + URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    logger.warn((Object)"Your OS doesn't support UTF-8, so we can encode", (Throwable)ex);
                    result.add(key + "=" + value);
                }
                continue;
            }
            result.add(key + "=" + value);
        }
        return result;
    }

    public static byte[] loadBinary(String classpathResource) {
        return Utils.loadBinary((Resource)new ClassPathResource(classpathResource));
    }

    public static byte[] loadBinary(Resource classpathResource) {
        InputStream stream = null;
        try {
            stream = classpathResource.getInputStream();
            byte[] byArray = Utils.unsafeLoadBinary(stream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Impossibile caricare la risorsa binaria '" + classpathResource.getDescription() + "' dal classpath.");
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    protected static byte[] unsafeLoadBinary(InputStream stream) throws IOException {
        return IOUtils.toByteArray((InputStream)stream);
    }

    public static String loadString(String classpathResource) {
        return Utils.loadString((Resource)new ClassPathResource(classpathResource));
    }

    public static String loadString(Resource classpathResource) {
        InputStream stream = null;
        try {
            stream = classpathResource.getInputStream();
            String string = Utils.unsafeLoadString(stream);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Impossibile caricare la risorsa testuale '" + classpathResource.getDescription() + "' dal classpath.");
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    protected static String unsafeLoadString(InputStream stream) throws IOException {
        byte[] byteResult = IOUtils.toByteArray((InputStream)stream);
        return Utils.stripUTF8preamble(new String(byteResult, "UTF-8"));
    }

    public static String stripUTF8preamble(String s) throws UnsupportedEncodingException {
        if (Utils.hasUTF8preamble(s)) {
            logger.debug((Object)"Rimosso header UTF-8 dalla stringa");
            return s.substring(1);
        }
        return s;
    }

    public static byte[] stripUTF8preamble(byte[] b) {
        byte[] result = null;
        if (Utils.hasUTF8preamble(b)) {
            logger.debug((Object)"Rimosso header UTF-8 dall'array");
            result = ArrayUtils.subarray((byte[])b, (int)UTF8_PREAMBLE.length, (int)b.length);
        }
        return result;
    }

    public static boolean hasUTF8preamble(byte[] b) {
        return b[0] == UTF8_PREAMBLE[0] && b[1] == UTF8_PREAMBLE[1] && b[2] == UTF8_PREAMBLE[2];
    }

    public static boolean hasUTF8preamble(String s) {
        return s.startsWith(UTF8_UNICODE_PREAMBLE);
    }

    public static String[] uncamelize(String camelString) {
        if (camelString == null || camelString.trim().equals("")) {
            throw new IllegalArgumentException("camelString cannot be null or empty");
        }
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        ArrayList<String> strList = new ArrayList<String>();
        Pattern p = Pattern.compile("\\p{Lu}");
        Matcher m = p.matcher(camelString);
        while (m.find()) {
            idxList.add(m.start());
        }
        if (idxList.size() == 0) {
            return new String[]{camelString};
        }
        Integer[] idx = idxList.toArray(new Integer[idxList.size() - 1]);
        for (int i = 0; i < idx.length; ++i) {
            if (i == 0 && idx[i] > 0) {
                strList.add(camelString.substring(0, idx[i]).toLowerCase());
            }
            if (i == idx.length - 1) {
                strList.add(camelString.substring(idx[i], camelString.length()).toLowerCase());
                continue;
            }
            strList.add(camelString.substring(idx[i], idx[i + 1]).toLowerCase());
        }
        return strList.toArray(new String[strList.size() - 1]);
    }
}

