/*
 * Decompiled with CFR 0.152.
 */
package org.lambico.test.spring.hibernate;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.lambico.dao.generic.GenericDaoBase;
import org.lambico.test.spring.EnhancedTestCase;
import org.lambico.test.spring.hibernate.DaoUtils;
import org.lambico.test.spring.hibernate.FixtureHelper;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class DBTest
extends EnhancedTestCase {
    private static Logger logger = Logger.getLogger(DBTest.class);
    protected Map<Class, Object[]> fixtures;
    @Resource
    protected SessionFactory sessionFactory;
    @Resource(name="daoMap")
    protected HashMap daoMap;

    public final Class[] getReverseOrderFixtureClasses() {
        Object[] models = this.getFixtureClasses();
        ArrayUtils.reverse((Object[])models);
        return models;
    }

    public Class[] getFixtureClasses() {
        return new Class[0];
    }

    public final Set<Class> getFixtureClassSet() {
        Object[] classes = this.getFixtureClasses();
        LinkedHashSet<Class> result = new LinkedHashSet<Class>(classes.length);
        CollectionUtils.addAll(result, (Object[])classes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetUpBeforeTransaction() throws Exception {
        Session session = this.sessionFactory.openSession();
        session.beginTransaction();
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder((org.hibernate.Session)session));
        TransactionSynchronizationManager.initSynchronization();
        try {
            GenericDaoBase dao;
            for (Class model : this.getReverseOrderFixtureClasses()) {
                dao = DaoUtils.getDaoFor(model, (ListableBeanFactory)this.applicationContext);
                FixtureHelper.eraseDbForModel(model, dao);
            }
            for (Class model : this.getFixtureClasses()) {
                dao = DaoUtils.getDaoFor(model, (ListableBeanFactory)this.applicationContext);
                FixtureHelper.populateDbForModel(model, this.fixtures.get(model), dao);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)"Rolling back the database transaction");
            session.getTransaction().rollback();
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                logger.info((Object)"Can't close the session! (ignore it)");
            }
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            TransactionSynchronizationManager.clearSynchronization();
        }
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:org/lambico/spring/dao/hibernate/genericDao.xml", "classpath:org/lambico/spring/dao/hibernate/applicationContextBase.xml", "classpath:applicationContext_test.xml"};
    }

    protected void prepareTestInstance() throws Exception {
        super.prepareTestInstance();
        Map<String, Object> ldaos = DaoUtils.getDaos((ListableBeanFactory)this.applicationContext);
        this.daoMap.putAll(ldaos);
        if (this.fixtures == null) {
            Set<Class> fixtureClasses = this.getFixtureClassSet();
            if (fixtureClasses != null && fixtureClasses.size() > 0) {
                try {
                    this.fixtures = FixtureHelper.loadFixturesFromResource((ClassPathResource)this.applicationContext.getResource("classpath:/fixtures/"), fixtureClasses);
                    logger.info((Object)("Loaded fixtures for classes " + this.fixtures.keySet().toString()));
                }
                catch (Exception e) {
                    logger.warn((Object)("I can't load all fixture for classes " + fixtureClasses.toString()), (Throwable)e);
                }
            } else {
                logger.info((Object)"No fixtures to load");
            }
        }
    }

    protected void endTransaction() {
        try {
            super.endTransaction();
        }
        catch (Exception ex) {
            logger.info((Object)"Expected false exception when ending transaction! (ignore it)");
        }
    }
}

