/*
 * Decompiled with CFR 0.152.
 */
package org.lambico.test.spring.hibernate;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.cfg.DefaultComponentSafeNamingStrategy;
import org.lambico.dao.generic.GenericDaoBase;
import org.lambico.dao.spring.hibernate.GenericDaoHibernateSupport;
import org.lambico.test.spring.Utils;
import org.parancoe.yaml.Yaml;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class FixtureHelper {
    private static Logger logger = Logger.getLogger(FixtureHelper.class);
    private static final Pattern HEADER_MATCH = Pattern.compile("^-\\s??(\\S*)\\s*?$", 8);
    private static final Pattern LINE_MATCH = Pattern.compile("^(.+)$", 8);

    protected FixtureHelper() {
    }

    public static String getFixtureFileName(Class model) {
        return model.getSimpleName() + ".yml";
    }

    public static String getFixtureDaoId(Class model) {
        return StringUtils.uncapitalize((String)model.getSimpleName()) + "Dao";
    }

    public static String getFixtureBusinessDaoId(Class model) {
        return StringUtils.uncapitalize((String)model.getSimpleName()) + "BusinessDao";
    }

    public static String getModelName(Class model) {
        return model.getSimpleName();
    }

    public static Map<Class, Object[]> loadFixturesFromResource(String classpathResource, Set<Class> models) {
        return FixtureHelper.loadFixturesFromResource(new ClassPathResource(classpathResource), models);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map<Class, Object[]> loadFixturesFromResource(ClassPathResource fixtureDir, Set<Class> models) {
        Object any;
        LinkedHashMap<Class, Object[]> fixtures = new LinkedHashMap<Class, Object[]>(models.size());
        String fixtureFileName = null;
        StringBuffer sb = new StringBuffer();
        for (Class model : models) {
            InputStream stream;
            block13: {
                fixtureFileName = fixtureDir.getPath() + FixtureHelper.getFixtureFileName(model);
                stream = null;
                try {
                    ClassPathResource fixtureResource = new ClassPathResource(fixtureFileName);
                    stream = fixtureResource.getInputStream();
                    String content = FixtureHelper.loadFixtureStringForClass((Resource)fixtureResource, model);
                    if (StringUtils.isNotBlank((String)content)) {
                        sb.append(content);
                        sb.append(IOUtils.LINE_SEPARATOR);
                        fixtures.put(model, null);
                        break block13;
                    }
                    logger.warn((Object)("Non ho trovato fixtures per " + FixtureHelper.getModelName(model) + " dentro il file '" + fixtureFileName + "' ?"));
                }
                catch (FileNotFoundException e) {
                    logger.warn((Object)("Non ho trovato il file di fixtures per " + FixtureHelper.getModelName(model) + ", hai creato il file '" + fixtureFileName + "' ?"));
                    IOUtils.closeQuietly((InputStream)stream);
                    continue;
                }
                catch (IOException e2) {
                    logger.error((Object)("Fallito il caricamento delle fixtures per " + FixtureHelper.getModelName(model)), (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(stream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                    continue;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (sb.length() == 0) {
            sb.append("--- !java.lang.Object[]  []" + IOUtils.LINE_SEPARATOR);
        } else {
            sb.insert(0, "--- !java.lang.Object[]" + IOUtils.LINE_SEPARATOR);
        }
        sb.append("...");
        sb.append(IOUtils.LINE_SEPARATOR);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("### Inizio Yaml generato dal merge delle fixtures ###\n" + sb.toString() + "\n### Fine Yaml generato dal merge delle fixtures ###"));
        }
        if ((any = Yaml.load((String)sb.toString())) instanceof Object[]) {
            Object[] fixtureObjects;
            for (Object fixtureObject : fixtureObjects = (Object[])any) {
                Object[] objects = (Object[])fixtureObject;
                if (ArrayUtils.isEmpty((Object[])objects)) continue;
                fixtures.put(objects[0].getClass(), objects);
            }
        }
        return fixtures;
    }

    private static String loadFixtureStringForClass(Resource resource, Class model) throws IOException {
        String fixtureString = Utils.loadString(resource);
        Matcher matcher = HEADER_MATCH.matcher(fixtureString);
        fixtureString = matcher.replaceAll("- $1 !" + model.getName().replace("$", "\\$"));
        matcher = LINE_MATCH.matcher(fixtureString);
        fixtureString = matcher.replaceAll("  $1");
        return "- !" + model.getName() + "[]" + IOUtils.LINE_SEPARATOR + fixtureString;
    }

    public static void populateDbForModel(Class model, Object[] fixtures, GenericDaoBase dao) {
        logger.debug((Object)("Populating table for " + FixtureHelper.getModelName(model)));
        if (fixtures == null) {
            logger.warn((Object)("Non ci sono fixtures per " + FixtureHelper.getModelName(model) + ", hai creato il file '" + FixtureHelper.getFixtureFileName(model) + "'?"));
            return;
        }
        try {
            for (Object entity : fixtures) {
                dao.store(entity);
                ((GenericDaoHibernateSupport)dao).getHibernateTemplate().flush();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error populating rows in " + FixtureHelper.getModelName(model) + " table"), (Throwable)e);
        }
    }

    public static void eraseDbForModel(Class model, GenericDaoBase dao) {
        logger.debug((Object)("Erasing table for " + FixtureHelper.getModelName(model)));
        try {
            if (dao == null) {
                throw new IllegalArgumentException("Dao associated to " + model.getName() + " PO is null!");
            }
            int deleted = ((GenericDaoHibernateSupport)dao).getHibernateTemplate().bulkUpdate("DELETE FROM " + DefaultComponentSafeNamingStrategy.INSTANCE.tableName(model.getSimpleName()));
        }
        catch (Exception e) {
            logger.error((Object)("Error deleting rows in " + FixtureHelper.getModelName(model) + " table"), (Throwable)e);
        }
    }
}

