/*
 * Decompiled with CFR 0.152.
 */
package com.lamblin.test.common;

import com.lamblin.test.common.TestRunnerConfigExtractor;
import com.lamblin.test.config.LamblinTestConfig;
import com.lamblin.test.config.TestRunnerConfig;
import com.lamblin.test.config.annotation.LamblinTestRunnerConfig;
import com.lamblin.test.exception.IllegalTestConfigClassException;
import com.lamblin.test.exception.TestRunnerConfigAnnotationMissingException;
import java.lang.annotation.Annotation;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/lamblin/test/common/DefaultTestRunnerConfigExtractor;", "Lcom/lamblin/test/common/TestRunnerConfigExtractor;", "()V", "extractConfigFromTestClass", "Lcom/lamblin/test/config/TestRunnerConfig;", "testClass", "Ljava/lang/Class;", "getControllerInstances", "", "", "configClass", "Lkotlin/reflect/KClass;", "lamblin-test"})
public final class DefaultTestRunnerConfigExtractor
implements TestRunnerConfigExtractor {
    public static final DefaultTestRunnerConfigExtractor INSTANCE;

    @Override
    @NotNull
    public TestRunnerConfig extractConfigFromTestClass(@NotNull Class<?> testClass) {
        Annotation annotation;
        Annotation annotation2;
        block3: {
            Annotation[] annotationArray;
            Intrinsics.checkParameterIsNotNull(testClass, (String)"testClass");
            Annotation[] annotationArray2 = testClass.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationArray2, (String)"testClass.annotations");
            for (Annotation annotation3 : annotationArray = annotationArray2) {
                Annotation it = annotation3;
                if (!(it instanceof LamblinTestRunnerConfig)) continue;
                annotation2 = annotation3;
                break block3;
            }
            annotation2 = annotation = null;
        }
        if (!(annotation2 instanceof LamblinTestRunnerConfig)) {
            annotation = null;
        }
        LamblinTestRunnerConfig lamblinTestRunnerConfig = (LamblinTestRunnerConfig)annotation;
        if (lamblinTestRunnerConfig == null) {
            throw (Throwable)new TestRunnerConfigAnnotationMissingException("LamblinTestRunnerConfig annotation missing on class " + testClass.getName());
        }
        LamblinTestRunnerConfig testRunnerConfig = lamblinTestRunnerConfig;
        return new TestRunnerConfig(testRunnerConfig.serverPort(), this.getControllerInstances(Reflection.getOrCreateKotlinClass(testRunnerConfig.testConfigClass())));
    }

    private final Set<Object> getControllerInstances(KClass<?> configClass) {
        Object object = KClasses.createInstance(configClass);
        if (!(object instanceof LamblinTestConfig)) {
            object = null;
        }
        LamblinTestConfig lamblinTestConfig = (LamblinTestConfig)object;
        if (lamblinTestConfig == null) {
            throw (Throwable)new IllegalTestConfigClassException("Config class " + configClass.getQualifiedName() + " should implement LamblinTestConfig");
        }
        LamblinTestConfig configClassInstance = lamblinTestConfig;
        return configClassInstance.controllers();
    }

    private DefaultTestRunnerConfigExtractor() {
    }

    static {
        DefaultTestRunnerConfigExtractor defaultTestRunnerConfigExtractor;
        INSTANCE = defaultTestRunnerConfigExtractor = new DefaultTestRunnerConfigExtractor();
    }
}

