/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io;

import com.floreysoft.jmte.Engine;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import jp.go.nict.langrid.client.soap.io.parameter.Encoder;
import jp.go.nict.langrid.client.soap.io.parameter.EncoderUtil;
import jp.go.nict.langrid.client.soap.io.parameter.Encoders;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.lang.ClassResource;
import jp.go.nict.langrid.commons.lang.ClassResourceLoader;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.rpc.intf.Service;
import jp.go.nict.langrid.commons.transformer.UTF8ByteArrayToStringTransformer;
import org.apache.commons.lang.StringEscapeUtils;

public class SoapRequestWriter {
    @ClassResource(path="/SoapRequest.tmpl.jmte", converter=UTF8ByteArrayToStringTransformer.class)
    private static String template;
    private static Engine jmte;

    public static void writeSoapRequest(OutputStream os, Iterable<RpcHeader> headers, Method method, Object ... args) throws IOException, IllegalAccessException, InvocationTargetException {
        SoapRequestWriter.writeSoapRequest(os, null, headers, method, args);
    }

    public static void writeSoapRequest(OutputStream os, String namespace, Iterable<RpcHeader> headers, Method method, Object ... args) throws IOException, IllegalAccessException, InvocationTargetException {
        Service sa = method.getDeclaringClass().getAnnotation(Service.class);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] paramAnnots = method.getParameterAnnotations();
        ArrayList<Encoder> params = new ArrayList<Encoder>();
        int n = paramTypes.length;
        for (int i = 0; i < n; ++i) {
            String name = EncoderUtil.getParameterName(paramAnnots[i]);
            if (name == null) {
                name = "in" + i;
            }
            params.add(Encoders.create(3, name, paramTypes[i], args[i]));
        }
        String ns = namespace;
        if (ns == null) {
            if (sa != null && sa.namespace().length() > 0) {
                ns = sa.namespace();
            } else {
                String sn = method.getDeclaringClass().getSimpleName();
                if (sn.endsWith("Service")) {
                    sn = sn.substring(0, sn.length() - 7);
                }
                ns = "servicegrid:servicetype:nict.nlp:" + sn;
            }
        }
        bindings.put("namespace", ns);
        bindings.put("headers", SoapRequestWriter.escapeValueXml(headers));
        bindings.put("methodName", method.getName());
        bindings.put("parameters", params);
        StreamUtil.writeString((OutputStream)os, (String)jmte.transform(template, bindings), (String)"UTF-8");
    }

    private static Iterable<RpcHeader> escapeValueXml(Iterable<RpcHeader> v) {
        ArrayList<RpcHeader> r = new ArrayList<RpcHeader>();
        for (RpcHeader h : v) {
            r.add(new RpcHeader(h.getNamespace(), h.getName(), StringEscapeUtils.escapeXml((String)h.getValue())));
        }
        return r;
    }

    static {
        try {
            ClassResourceLoader.load(SoapRequestWriter.class);
            jmte = Engine.createNonCachingEngine();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

