/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io.parameter;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jp.go.nict.langrid.client.soap.io.parameter.Encoder;
import jp.go.nict.langrid.client.soap.io.parameter.EncoderUtil;
import jp.go.nict.langrid.client.soap.io.parameter.Encoders;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.util.Pair;

public class BeanEncoder
extends Encoder {
    private String ns;
    private String type;
    private Encoder[] values;

    public BeanEncoder(int indent, String name, Class<?> type, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        super(indent, name);
        this.ns = EncoderUtil.getNamespace(type);
        this.type = type.getSimpleName();
        ArrayList<Encoder> params = new ArrayList<Encoder>();
        for (Pair p : ClassUtil.getReadableProperties(type)) {
            Method m = (Method)p.getSecond();
            params.add(Encoders.create(indent + 1, (String)p.getFirst(), m.getReturnType(), m.invoke(value, new Object[0])));
        }
        this.values = params.toArray(new Encoder[0]);
    }

    @Override
    public void write(PrintWriter writer) throws IOException {
        this.writeIndent(writer);
        writer.println(String.format("<%s %s xsi:type=\"ns:%s\" %s xmlns:ns=\"%s\">", this.getName(), "soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"", this.type, "xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"", this.ns));
        for (Encoder p : this.values) {
            p.write(writer);
        }
        this.writeClosingTag(writer);
    }
}

