/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io.parameter;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import jp.go.nict.langrid.client.soap.io.parameter.Encoder;
import jp.go.nict.langrid.client.soap.io.parameter.EncoderUtil;
import jp.go.nict.langrid.client.soap.io.parameter.Encoders;
import jp.go.nict.langrid.commons.io.CascadingIOException;

public class ArrayEncoder
extends Encoder {
    private Class<?> type;
    private Object value;

    public ArrayEncoder(int indent, String name, Class<?> type, Object value) {
        super(indent, name);
        this.type = type;
        this.value = value;
    }

    public static String getTagAttributes(Class<?> type, Object value) {
        StringBuilder brackets = new StringBuilder();
        do {
            brackets.append("[");
            Class<?> ct = type.getComponentType();
            if (!ct.isArray()) {
                brackets.append(Array.getLength(value));
            }
            brackets.append("]");
            type = ct;
            if (Array.getLength(value) == 0) continue;
            value = Array.get(value, 0);
        } while (type.isArray());
        String xsiType = EncoderUtil.typeToXsdType(type);
        if (xsiType != null) {
            return String.format("soapenc:arrayType=\"xsd:%s%s\" xsi:type=\"soapenc:Array\"", xsiType, brackets);
        }
        return String.format("soapenc:arrayType=\"ns:%s%s\" xsi:type=\"soapenc:Array\" xmlns:ns=\"%s\"", type.getSimpleName(), brackets, EncoderUtil.getNamespace(type));
    }

    @Override
    public void write(PrintWriter writer) throws IOException {
        Class<?> ct = this.type.getComponentType();
        int n = Array.getLength(this.value);
        this.writeIndent(writer);
        String tagAttributes = ArrayEncoder.getTagAttributes(this.type, this.value);
        writer.println(String.format("<%s %s %s>", this.getName(), tagAttributes, "xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\""));
        try {
            for (int i = 0; i < n; ++i) {
                Object element = Array.get(this.value, i);
                Encoders.create(this.getIndent() + 1, this.getName(), ct, element).write(writer);
            }
        }
        catch (IllegalAccessException e) {
            throw new CascadingIOException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new CascadingIOException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CascadingIOException((Throwable)e);
        }
        this.writeClosingTag(writer);
    }
}

