/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.go.nict.langrid.commons.beanutils.ConversionException;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.io.CascadingIOException;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.rpc.RpcFault;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.util.Trio;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SoapResponseParser {
    private static ThreadLocal<XPathWorkspace> workspace = new ThreadLocal<XPathWorkspace>(){

        @Override
        protected XPathWorkspace initialValue() {
            try {
                return new XPathWorkspace();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static ThreadLocal<DateFormat> fmt = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            f.setTimeZone(TimeZone.getTimeZone("GMT"));
            return f;
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Trio<Collection<RpcHeader>, RpcFault, T> parseSoapResponse(Class<T> returnType, String methodName, InputStream is, Converter converter) throws IOException, SAXException {
        Node res;
        ArrayList<RpcHeader> headers;
        block46: {
            headers = new ArrayList<RpcHeader>();
            XPathWorkspace w = workspace.get();
            try {
                Node body;
                Element envelope = w.docBuilder.parse(is).getDocumentElement();
                Node header = SoapResponseParser.findFirstChildNamed(envelope, "Header");
                if (header != null) {
                    Node h = header.getFirstChild();
                    while (h != null) {
                        if (h instanceof Element) {
                            headers.add(new RpcHeader(h.getNamespaceURI(), h.getLocalName(), h.getTextContent()));
                        }
                        h = h.getNextSibling();
                    }
                }
                if ((body = SoapResponseParser.findFirstChildNamed(envelope, "Body")) != null) {
                    res = body.getFirstChild();
                    while (res != null) {
                        if (res instanceof Element) {
                            if (res.getLocalName().equals(String.valueOf(methodName) + "Response")) {
                                Node ret = res.getFirstChild();
                                while (ret != null) {
                                    if (ret instanceof Element && ret.getLocalName().equals(String.valueOf(methodName) + "Return")) {
                                        try {
                                            T r = SoapResponseParser.nodeToType(w, ret, returnType, converter);
                                            Trio trio = new Trio(headers, null, r);
                                            return trio;
                                        }
                                        catch (IllegalArgumentException e) {
                                            throw new CascadingIOException((Throwable)e);
                                        }
                                        catch (InstantiationException e) {
                                            throw new CascadingIOException((Throwable)e);
                                        }
                                        catch (IllegalAccessException e) {
                                            throw new CascadingIOException((Throwable)e);
                                        }
                                        catch (InvocationTargetException e) {
                                            throw new CascadingIOException((Throwable)e);
                                        }
                                        catch (ParseException e) {
                                            throw new CascadingIOException((Throwable)e);
                                        }
                                    }
                                    ret = ret.getNextSibling();
                                }
                            } else if (res.getLocalName().equals("Fault")) break block46;
                        }
                        res = res.getNextSibling();
                    }
                }
                if (returnType.equals(Void.TYPE)) {
                    Trio trio = new Trio(headers, null, null);
                    return trio;
                }
                throw new IOException("not a valid SOAP message.");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        RpcFault f = new RpcFault();
        NodeList nl = res.getChildNodes();
        Converter c = new Converter();
        int i = 0;
        while (true) {
            if (i >= nl.getLength()) {
                return new Trio(headers, (Object)f, null);
            }
            Node n = nl.item(i);
            if (n instanceof Element) {
                if (n.getLocalName().equals("faultcode")) {
                    f.setFaultCode(n.getTextContent());
                } else if (n.getLocalName().equals("faultstring")) {
                    f.setFaultString(n.getTextContent());
                } else if (n.getLocalName().equals("detail")) {
                    String detail = n.getNodeValue();
                    f.setDetail(detail);
                    Node expTag = n.getFirstChild();
                    if (expTag != null) {
                        NodeList pl = expTag.getChildNodes();
                        try {
                            Class<?> expClass = Class.forName(expTag.getNodeName());
                            Object expInstance = expClass.newInstance();
                            int j = 0;
                            while (true) {
                                if (j >= pl.getLength()) {
                                    f.setFaultString(String.valueOf(expTag.getNodeName()) + ":" + JSON.encode(expInstance));
                                    break;
                                }
                                Node prop = pl.item(j);
                                String propName = prop.getNodeName();
                                Method setter = ClassUtil.findSetter(expClass, (String)propName);
                                if (setter != null) {
                                    try {
                                        setter.invoke(expInstance, c.convert((Object)prop.getTextContent(), setter.getParameterTypes()[0]));
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                    }
                                    catch (ConversionException conversionException) {
                                    }
                                    catch (DOMException dOMException) {
                                        // empty catch block
                                    }
                                }
                                ++j;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        finally {
            workspace.remove();
        }
    }

    private static Node findFirstChildNamed(Node parent, String localName) {
        Node n = parent.getFirstChild();
        while (!(n == null || n.getNodeType() == 1 && n.getLocalName().equals(localName))) {
            n = n.getNextSibling();
        }
        return n;
    }

    private static Node findFirstDescendantHasAttr(Node parent, String attrName, String attrValue) {
        if (parent == null) {
            return null;
        }
        Node n = parent.getFirstChild();
        while (n != null) {
            Node attr;
            NamedNodeMap attrs = n.getAttributes();
            if (attrs != null && (attr = attrs.getNamedItem(attrName)) != null && attr.getNodeValue().equals(attrValue)) {
                return n;
            }
            Node d = SoapResponseParser.findFirstDescendantHasAttr(n, attrName, attrValue);
            if (d != null) {
                return d;
            }
            n = n.getNextSibling();
        }
        return n;
    }

    private static <T> T nodeToType(XPathWorkspace w, Node node, Class<T> clazz, Converter converter) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ConversionException, DOMException, ParseException {
        if (clazz.isPrimitive()) {
            return (T)converter.convert((Object)SoapResponseParser.resolveHref(w, node).getTextContent(), clazz);
        }
        if (clazz.equals(String.class)) {
            return clazz.cast(SoapResponseParser.resolveHref(w, node).getTextContent());
        }
        if (clazz.equals(byte[].class)) {
            try {
                return clazz.cast(Base64.decodeBase64((byte[])SoapResponseParser.resolveHref(w, node).getTextContent().getBytes("ISO8859-1")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (clazz.equals(Calendar.class)) {
            Date date = fmt.get().parse(SoapResponseParser.resolveHref(w, node).getTextContent());
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return clazz.cast(c);
        }
        if (clazz.isArray()) {
            Class<?> ct = clazz.getComponentType();
            ArrayList elements = new ArrayList();
            node = SoapResponseParser.resolveHref(w, node);
            Node child = node.getFirstChild();
            while (child != null) {
                if (child instanceof Element) {
                    elements.add(SoapResponseParser.nodeToType(w, child, ct, converter));
                }
                child = child.getNextSibling();
            }
            return clazz.cast(elements.toArray((Object[])Array.newInstance(ct, elements.size())));
        }
        T instance = clazz.newInstance();
        node = SoapResponseParser.resolveHref(w, node);
        Node child = node.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                String nn = child.getLocalName();
                Method setter = ClassUtil.findSetter(clazz, (String)nn);
                setter.invoke(instance, SoapResponseParser.nodeToType(w, SoapResponseParser.resolveHref(w, child), setter.getParameterTypes()[0], converter));
            }
            child = child.getNextSibling();
        }
        return instance;
    }

    private static Node resolveHref(XPathWorkspace w, Node node) throws DOMException {
        Node href = node.getAttributes().getNamedItem("href");
        if (href != null) {
            return SoapResponseParser.findFirstDescendantHasAttr(node.getOwnerDocument().getDocumentElement(), "id", href.getTextContent().substring(1));
        }
        return node;
    }

    private static class XPathWorkspace {
        private DocumentBuilder docBuilder;

        public XPathWorkspace() throws ParserConfigurationException {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            this.docBuilder = f.newDocumentBuilder();
        }
    }
}

