/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io.parameter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.go.nict.langrid.client.soap.io.parameter.ArrayEncoder;
import jp.go.nict.langrid.client.soap.io.parameter.BeanEncoder;
import jp.go.nict.langrid.client.soap.io.parameter.BytesEncoder;
import jp.go.nict.langrid.client.soap.io.parameter.CalendarEncoder;
import jp.go.nict.langrid.client.soap.io.parameter.DateEncoder;
import jp.go.nict.langrid.client.soap.io.parameter.Encoder;
import jp.go.nict.langrid.client.soap.io.parameter.EncoderUtil;
import jp.go.nict.langrid.client.soap.io.parameter.ToStringEncoder;

public class Encoders {
    private static Map<Class<?>, Constructor<? extends Encoder>> ctors = new HashMap();

    static {
        try {
            ctors.put(byte[].class, Encoders.getCtor(BytesEncoder.class));
            ctors.put(Calendar.class, Encoders.getCtor(CalendarEncoder.class));
            ctors.put(Date.class, Encoders.getCtor(DateEncoder.class));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Encoder create(int indent, String name, Class<?> type, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends Encoder> ctor = ctors.get(type);
        if (ctor != null) {
            try {
                return ctor.newInstance(indent, name, value);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (EncoderUtil.isSimpleType(type)) {
            return new ToStringEncoder(indent, name, type, value);
        }
        if (type.isArray()) {
            return new ArrayEncoder(indent, name, type, value);
        }
        return new BeanEncoder(indent, name, type, value);
    }

    private static Constructor<? extends Encoder> getCtor(Class<? extends Encoder> clazz) throws SecurityException, NoSuchMethodException {
        return clazz.getConstructor(Integer.TYPE, String.class, Object.class);
    }
}

