/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.function.Predicate;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.RequestAttributes;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.util.function.Filters;

public class TestContext {
    private ClientFactory factory;
    private String baseUrl;
    private String userId;
    private String password;

    public TestContext(ClientFactory factory) throws IOException {
        this(TestContext.getBaseClass(), factory);
    }

    private static Class<?> getBaseClass() {
        try {
            return Class.forName(new Exception().getStackTrace()[2].getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public TestContext(Class<?> base, ClientFactory factory) throws IOException {
        Iterator it;
        this.factory = factory;
        InputStream is = base.getResourceAsStream("TestContext_url");
        if (is == null) {
            throw new RuntimeException("TestContext_url is needed beside the test class and also Context_auth if needed.");
        }
        try {
            it = StreamUtil.readLines((Reader)new InputStreamReader(is, "UTF-8"), (Predicate)Filters.ignoreBlankAndComment()).iterator();
            if (!it.hasNext()) {
                throw new RuntimeException("no information in Context_url");
            }
            this.baseUrl = (String)it.next();
        }
        finally {
            is.close();
        }
        is = base.getResourceAsStream("TestContext_auth");
        if (is == null) {
            return;
        }
        try {
            it = StreamUtil.readLines((Reader)new InputStreamReader(is, "UTF-8"), (Predicate)Filters.ignoreBlankAndComment()).iterator();
            if (it.hasNext()) {
                this.userId = (String)it.next();
            }
            if (it.hasNext()) {
                this.password = (String)it.next();
            }
        }
        finally {
            is.close();
        }
    }

    public <T> T createClient(String name, Class<T> clazz) {
        Object c = this.factory.create(clazz, this.url(name));
        RequestAttributes reqAttrs = (RequestAttributes)c;
        if (this.userId != null) {
            reqAttrs.setUserId(this.userId);
            reqAttrs.setPassword(this.password);
        }
        return (T)c;
    }

    private URL url(String name) {
        try {
            return new URL(String.valueOf(this.baseUrl) + name);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

