/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.ws_1_2.error;

import java.net.URL;
import java.util.Calendar;
import java.util.Locale;
import jp.go.nict.langrid.client.ws_1_2.error.LangridError;
import jp.go.nict.langrid.commons.util.ArrayUtil;
import jp.go.nict.langrid.commons.util.CalendarUtil;

public class LangridException
extends Exception {
    private URL serviceUrl;
    private String operationName;
    private Object[] operationParameters;
    private LangridError error;
    private static final long serialVersionUID = -2554093624509897933L;

    public LangridException(Throwable cause, URL serviceUrl, String operationName, Object[] operationParameters, LangridError error) {
        super(cause);
        this.serviceUrl = serviceUrl;
        this.operationName = operationName;
        this.operationParameters = operationParameters;
        this.error = error;
    }

    public LangridException(String message, URL serviceUrl, String operationName, Object[] operationParameters, LangridError error) {
        super(message);
        this.serviceUrl = serviceUrl;
        this.operationName = operationName;
        this.operationParameters = operationParameters;
        this.error = error;
    }

    public LangridError getError() {
        return this.error;
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getErrorString() {
        if (this.getCause() != null) {
            return String.format("%s: %s", this.error.name(), this.error.getMessage(this.getCause()));
        }
        return String.format("%s: %s", this.error.name(), super.getMessage());
    }

    public String getErrorString(Locale locale) {
        return String.format("%s: %s", this.error.name(), this.error.getMessage(this.getCause(), locale));
    }

    public String getOperationString() {
        String url = this.serviceUrl.toString();
        int qi = url.indexOf(63);
        if (qi != -1) {
            url = url.substring(0, qi);
        }
        StringBuilder b = new StringBuilder(String.format("%s#%s(", url, this.operationName));
        boolean first = true;
        Object[] objectArray = this.operationParameters;
        int n = this.operationParameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object p = objectArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            if (p == null) {
                b.append("null");
            } else if (p instanceof String) {
                b.append("\"");
                b.append(p);
                b.append("\"");
            } else if (p instanceof Calendar) {
                b.append("\"");
                b.append(CalendarUtil.formatToDefault((Calendar)((Calendar)p)));
                b.append("\"");
            } else if (p.getClass().isArray()) {
                b.append(ArrayUtil.toString((Object)p));
            } else {
                b.append(p);
            }
            ++n2;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getMessage() {
        return String.valueOf(this.getErrorString()) + " [" + this.getOperationString() + "]";
    }

    public String getMessage(Locale locale) {
        return String.valueOf(this.getErrorString(locale)) + " [" + this.getOperationString() + "]";
    }
}

