/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.ws_1_2.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import jp.go.nict.langrid.client.ws_1_2.ServiceClient;
import jp.go.nict.langrid.client.ws_1_2.error.ExceptionConverter;
import jp.go.nict.langrid.client.ws_1_2.error.LangridException;
import jp.go.nict.langrid.commons.beanutils.ConversionException;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.cs.binding.BindingNode;
import jp.go.nict.langrid.commons.cs.binding.DynamicBindingUtil;
import jp.go.nict.langrid.commons.cs.calltree.CallNode;
import jp.go.nict.langrid.commons.cs.calltree.CallTreeUtil;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.ws.soap.SoapHeaderRpcHeadersAdapter;
import jp.go.nict.langrid.service_1_2.transformer.StringToDictMatchingMethodTransformer;
import jp.go.nict.langrid.service_1_2.transformer.StringToPartOfSpeechTransformer;
import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public abstract class ServiceClientImpl
implements ServiceClient,
Serializable {
    private URL url;
    private String userId;
    private String password;
    private transient Stub stub;
    private transient boolean treeBindingMayChanged;
    private Collection<BindingNode> treeBindings = new ArrayList<BindingNode>();
    private Hashtable<String, String> httpHeaders = new Hashtable();
    private String lastName;
    private String lastCopyright;
    private String lastLicense;
    private Collection<CallNode> lastCallTree = new ArrayList<CallNode>();
    private static Converter converter = new Converter();
    private static final long serialVersionUID = 5708773854342542725L;

    public ServiceClientImpl(URL url) {
        this.url = url;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
        if (this.stub != null) {
            this.stub.setUsername(userId);
        }
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        if (this.stub != null) {
            this.stub.setPassword(password);
        }
    }

    @Override
    public Collection<BindingNode> getTreeBindings() {
        this.treeBindingMayChanged = true;
        return this.treeBindings;
    }

    @Override
    public void addRequestHeader(String name, String value) {
        this.httpHeaders.put(name, value);
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getLastCopyrightInfo() {
        return this.lastCopyright;
    }

    @Override
    public String getLastLicenseInfo() {
        return this.lastLicense;
    }

    @Override
    public Collection<CallNode> getLastCallTree() {
        return this.lastCallTree;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invoke(Object ... arguments) throws LangridException {
        StackTraceElement ste = Thread.currentThread().getStackTrace()[2];
        String methodName = ste.getMethodName();
        Stub s = null;
        try {
            s = this.getStub();
        }
        catch (ServiceException e) {
            throw ExceptionConverter.convertToE000(e, this.url, methodName, arguments);
        }
        Method selfMethod = null;
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().equals(methodName) || !this.isAssignableFrom(m.getParameterTypes(), arguments)) continue;
            selfMethod = m;
            break;
        }
        if (selfMethod == null) {
            throw ExceptionConverter.convertToE000("no suitable self method.", this.url, methodName, arguments);
        }
        Object[] convertedArgs = null;
        try {
            Method[] methodArray = s.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                block26: {
                    Method m = methodArray[n2];
                    if (m.getName().equals(methodName)) {
                        try {
                            convertedArgs = this.convert(arguments, m.getParameterTypes());
                        }
                        catch (ConversionException conversionException) {
                            break block26;
                        }
                        Object object = m.invoke((Object)s, convertedArgs);
                        Object obj = this.convert(object, selfMethod.getReturnType());
                        return obj;
                    }
                }
                ++n2;
            }
            throw new RuntimeException("no suitable stub method.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("IllegalArgumentException. actual args:");
            Object[] objectArray = convertedArgs;
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                void var11_23 = objectArray[n3];
                System.out.println(var11_23.getClass() + ": \"" + var11_23 + "\"");
                ++n3;
            }
            throw ExceptionConverter.convertToE000(e, this.url, methodName, arguments);
        }
        catch (IllegalAccessException e) {
            throw ExceptionConverter.convertToE000(e, this.url, methodName, arguments);
        }
        catch (InvocationTargetException e) {
            throw ExceptionConverter.convert(e, this.url, methodName, arguments);
        }
        finally {
            Message message = null;
            if (s._getCall() != null) {
                message = s._getCall().getMessageContext().getResponseMessage();
            }
            if (message == null) {
                this.lastName = null;
                this.lastCopyright = null;
                this.lastLicense = null;
                this.lastCallTree = null;
            } else {
                MimeHeaders headers = message.getMimeHeaders();
                this.lastName = this.getJoinedAndDecodedHeader(headers, "X-LanguageGrid-ServiceName", "<br>");
                this.lastCopyright = this.getJoinedAndDecodedHeader(headers, "X-LanguageGrid-ServiceCopyright", "<br>");
                this.lastLicense = this.getJoinedAndDecodedHeader(headers, "X-LanguageGrid-ServiceLicense", "<br>");
                try {
                    this.lastCallTree = CallTreeUtil.extractNodes((Iterable)new SoapHeaderRpcHeadersAdapter(message.getSOAPHeader()));
                }
                catch (SOAPException sOAPException) {
                }
                catch (ParseException parseException) {}
            }
        }
    }

    protected abstract Stub createStub(URL var1) throws ServiceException;

    protected <T> T convert(Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        if (targetClass.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        return (T)converter.convert(source, targetClass);
    }

    protected void setUpService(Service service) {
        AxisEngine engine = service.getEngine();
        Hashtable headers = (Hashtable)engine.getOption("HTTP-Request-Headers");
        if (headers != null) {
            for (Map.Entry e : headers.entrySet()) {
                this.httpHeaders.put((String)e.getKey(), (String)e.getValue());
            }
        }
        engine.setOption("HTTP-Request-Headers", this.httpHeaders);
    }

    private Stub getStub() throws ServiceException {
        if (this.stub == null) {
            this.stub = this.createStub(this.url);
            this.stub.setUsername(this.userId);
            this.stub.setPassword(this.password);
        }
        this.setUpStubHeaders();
        return this.stub;
    }

    private void setUpStubHeaders() {
        if (this.stub == null) {
            return;
        }
        if (!this.treeBindingMayChanged) {
            return;
        }
        this.stub.clearHeaders();
        String tvalue = DynamicBindingUtil.encodeTree(this.treeBindings);
        if (tvalue.length() > 0) {
            this.stub.setHeader("http://langrid.nict.go.jp/process/binding/tree", "binding", (Object)tvalue);
        }
        this.treeBindingMayChanged = false;
    }

    private String getJoinedAndDecodedHeader(MimeHeaders headers, String headerName, String separator) {
        String[] values = headers.getHeader(headerName);
        if (values != null) {
            try {
                return URLDecoder.decode(StringUtil.join((String[])values, (String)separator), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean isAssignableFrom(Class<?>[] argTypes, Object[] args) {
        if (argTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            if (args[i] == null) {
                if (!argTypes[i].isPrimitive()) continue;
                return false;
            }
            if (ClassUtil.isAssignableFrom(argTypes[i], args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private Object[] convert(Object[] arguments, Class<?>[] convertTypes) throws ConversionException {
        if (arguments.length != convertTypes.length) {
            throw new ConversionException("length not match.");
        }
        Object[] convertedArgs = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            convertedArgs[i] = converter.convert(arguments[i], convertTypes[i]);
        }
        return convertedArgs;
    }

    static {
        converter.addTransformerConversion((Transformer)new StringToPartOfSpeechTransformer());
        converter.addTransformerConversion((Transformer)new StringToDictMatchingMethodTransformer());
    }
}

