/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.ws_1_2;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.logging.Logger;
import jp.go.nict.langrid.client.axis.ProxySelectingAxisSocketFactory;
import jp.go.nict.langrid.client.axis.ProxySelectingSecureAxisSocketFactory;
import jp.go.nict.langrid.client.ws_1_2.AdjacencyPairClient;
import jp.go.nict.langrid.client.ws_1_2.BackTranslationClient;
import jp.go.nict.langrid.client.ws_1_2.BackTranslationWithTemporalDictionaryClient;
import jp.go.nict.langrid.client.ws_1_2.BilingualDictionaryClient;
import jp.go.nict.langrid.client.ws_1_2.BilingualDictionaryHeadwordsExtractionClient;
import jp.go.nict.langrid.client.ws_1_2.BilingualDictionaryWithLongestMatchSearchClient;
import jp.go.nict.langrid.client.ws_1_2.ConceptDictionaryClient;
import jp.go.nict.langrid.client.ws_1_2.DependencyParserClient;
import jp.go.nict.langrid.client.ws_1_2.DictionaryClient;
import jp.go.nict.langrid.client.ws_1_2.LanguageIdentificationClient;
import jp.go.nict.langrid.client.ws_1_2.MetadataForParallelTextClient;
import jp.go.nict.langrid.client.ws_1_2.MorphologicalAnalysisClient;
import jp.go.nict.langrid.client.ws_1_2.MultihopBackTranslationClient;
import jp.go.nict.langrid.client.ws_1_2.MultihopTranslationClient;
import jp.go.nict.langrid.client.ws_1_2.ParallelTextClient;
import jp.go.nict.langrid.client.ws_1_2.ParallelTextWithEmbeddedMetadataClient;
import jp.go.nict.langrid.client.ws_1_2.ParallelTextWithExternalMetadataClient;
import jp.go.nict.langrid.client.ws_1_2.ParallelTextWithIdClient;
import jp.go.nict.langrid.client.ws_1_2.ParaphraseClient;
import jp.go.nict.langrid.client.ws_1_2.PictogramDictionaryClient;
import jp.go.nict.langrid.client.ws_1_2.QualityEstimationClient;
import jp.go.nict.langrid.client.ws_1_2.ServiceClient;
import jp.go.nict.langrid.client.ws_1_2.SimilarityCalculationClient;
import jp.go.nict.langrid.client.ws_1_2.SpeechRecognitionClient;
import jp.go.nict.langrid.client.ws_1_2.TemplateParallelTextClient;
import jp.go.nict.langrid.client.ws_1_2.TextToSpeechClient;
import jp.go.nict.langrid.client.ws_1_2.TranslationClient;
import jp.go.nict.langrid.client.ws_1_2.TranslationSelectionClient;
import jp.go.nict.langrid.client.ws_1_2.TranslationWithTemporalDictionaryClient;
import jp.go.nict.langrid.client.ws_1_2.impl.AxisStubUtil;
import jp.go.nict.langrid.client.ws_1_2.impl.ServiceClientAxisStubAdapter;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.AdjacencyPairClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.BackTranslationClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.BackTranslationWithTemporalDictionaryClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.BilingualDictionaryClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.BilingualDictionaryHeadwordsExtractionClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.BilingualDictionaryWithLongestMatchSearchClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.ConceptDictionaryClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.DependencyParserClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.DictionaryClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.LanguageIdentificationClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.MetadataForParallelTextClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.MorphologicalAnalysisClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.MultihopBackTranslationClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.MultihopTranslationClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.ParallelTextClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.ParallelTextWithEmbeddedMetadataClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.ParallelTextWithExternalMetadataClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.ParallelTextWithIdClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.ParaphraseClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.PictogramDictionaryClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.QualityEstimationClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.SimilarityCalculationClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.SpeechRecognitionClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.TemplateParallelTextClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.TextToSpeechClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.TranslationClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.TranslationSelectionClientImpl;
import jp.go.nict.langrid.client.ws_1_2.impl.langservice.TranslationWithTemporalDictionaryClientImpl;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.beanutils.DynamicInvocationHandler;
import jp.go.nict.langrid.commons.net.proxy.pac.PacUtil;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.service_1_2.transformer.StringToDictMatchingMethodTransformer;
import jp.go.nict.langrid.service_1_2.transformer.StringToPartOfSpeechTransformer;
import org.apache.axis.client.Stub;

public class ClientFactory {
    private static String defaultUserId;
    private static String defaultPassword;
    private static Logger logger;
    private static Converter converter;

    public static TranslationClient createTranslationClient(URL serviceUrl) {
        return ClientFactory.setup(new TranslationClientImpl(serviceUrl));
    }

    public static <T extends ServiceClient> T createClient(Class<T> clientIntf, Class<?> serviceIntf, URL serviceUrl) {
        Stub stub = AxisStubUtil.createStub(serviceIntf);
        final ServiceClientAxisStubAdapter sc = new ServiceClientAxisStubAdapter(stub, serviceUrl);
        final DynamicInvocationHandler handler = new DynamicInvocationHandler((Object)stub, converter);
        return (T)((ServiceClient)clientIntf.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clientIntf}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(ServiceClient.class)) {
                    try {
                        return method.invoke((Object)sc, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                try {
                    sc.preInvoke();
                    Object object = handler.invoke(proxy, method, args);
                    return object;
                }
                finally {
                    sc.postInvoke();
                }
            }
        })));
    }

    public static TranslationWithTemporalDictionaryClient createTranslationWithTemporalDictionaryClient(URL serviceUrl) {
        return ClientFactory.setup(new TranslationWithTemporalDictionaryClientImpl(serviceUrl));
    }

    public static BackTranslationClient createBackTranslationClient(URL serviceUrl) {
        return ClientFactory.setup(new BackTranslationClientImpl(serviceUrl));
    }

    public static BackTranslationWithTemporalDictionaryClient createBackTranslationWithTemporalDictionaryClient(URL serviceUrl) {
        return ClientFactory.setup(new BackTranslationWithTemporalDictionaryClientImpl(serviceUrl));
    }

    public static MultihopTranslationClient createMultihopTranslationClient(URL serviceUrl) {
        return ClientFactory.setup(new MultihopTranslationClientImpl(serviceUrl));
    }

    public static MultihopBackTranslationClient createMultihopBackTranslationClient(URL serviceUrl) {
        return ClientFactory.setup(new MultihopBackTranslationClientImpl(serviceUrl));
    }

    public static DictionaryClient createDictionaryClient(URL serviceUrl) {
        return ClientFactory.setup(new DictionaryClientImpl(serviceUrl));
    }

    public static AdjacencyPairClient createAdjacencyPairClient(URL serviceUrl) {
        return ClientFactory.setup(new AdjacencyPairClientImpl(serviceUrl));
    }

    public static BilingualDictionaryClient createBilingualDictionaryClient(URL serviceUrl) {
        return ClientFactory.setup(new BilingualDictionaryClientImpl(serviceUrl));
    }

    public static BilingualDictionaryHeadwordsExtractionClient createBilingualDictionaryHeadwordsExtractionClient(URL serviceUrl) {
        return ClientFactory.setup(new BilingualDictionaryHeadwordsExtractionClientImpl(serviceUrl));
    }

    public static ParallelTextClient createParallelTextClient(URL serviceUrl) {
        return ClientFactory.setup(new ParallelTextClientImpl(serviceUrl));
    }

    public static ParallelTextWithIdClient createParallelTextWithIdClient(URL serviceUrl) {
        return ClientFactory.setup(new ParallelTextWithIdClientImpl(serviceUrl));
    }

    public static ParaphraseClient createParaphraseClient(URL serviceUrl) {
        return ClientFactory.setup(new ParaphraseClientImpl(serviceUrl));
    }

    public static MorphologicalAnalysisClient createMorphologicalAnalysisClient(URL serviceUrl) {
        return ClientFactory.setup(new MorphologicalAnalysisClientImpl(serviceUrl));
    }

    public static SimilarityCalculationClient createSimilarityCalculationClient(URL serviceUrl) {
        return ClientFactory.setup(new SimilarityCalculationClientImpl(serviceUrl));
    }

    public static PictogramDictionaryClient createPictogramDictionaryClient(URL serviceUrl) {
        return ClientFactory.setup(new PictogramDictionaryClientImpl(serviceUrl));
    }

    public static ConceptDictionaryClient createConceptDictionaryClient(URL serviceUrl) {
        return ClientFactory.setup(new ConceptDictionaryClientImpl(serviceUrl));
    }

    public static DependencyParserClient createDependencyParserClient(URL serviceUrl) {
        return ClientFactory.setup(new DependencyParserClientImpl(serviceUrl));
    }

    public static ParallelTextWithEmbeddedMetadataClient createParallelTextWithMetadataClient(URL serviceUrl) {
        return ClientFactory.setup(new ParallelTextWithEmbeddedMetadataClientImpl(serviceUrl));
    }

    public static ParallelTextWithExternalMetadataClient createParallelTextWithMetadataFromCandidateClient(URL serviceUrl) {
        return ClientFactory.setup(new ParallelTextWithExternalMetadataClientImpl(serviceUrl));
    }

    public static MetadataForParallelTextClient createMetadataForParallelTextClient(URL serviceUrl) {
        return ClientFactory.setup(new MetadataForParallelTextClientImpl(serviceUrl));
    }

    public static BilingualDictionaryWithLongestMatchSearchClient createBilingualDictionaryWithLongestMatchSearchClient(URL serviceUrl) {
        return ClientFactory.setup(new BilingualDictionaryWithLongestMatchSearchClientImpl(serviceUrl));
    }

    public static TextToSpeechClient createTextToSpeechClient(URL serviceUrl) {
        return ClientFactory.setup(new TextToSpeechClientImpl(serviceUrl));
    }

    public static SpeechRecognitionClient createSpeechRecognitionClient(URL serviceUrl) {
        return ClientFactory.setup(new SpeechRecognitionClientImpl(serviceUrl));
    }

    public static LanguageIdentificationClient createLanguageIdentificationClient(URL serviceUrl) {
        return ClientFactory.setup(new LanguageIdentificationClientImpl(serviceUrl));
    }

    public static TemplateParallelTextClient createTemplateParallelTextClient(URL serviceUrl) {
        return ClientFactory.setup(new TemplateParallelTextClientImpl(serviceUrl));
    }

    public static TranslationSelectionClient createTranslationSelectionClient(URL serviceUrl) {
        return ClientFactory.setup(new TranslationSelectionClientImpl(serviceUrl));
    }

    public static QualityEstimationClient createQualityEstimationClient(URL serviceUrl) {
        return ClientFactory.setup(new QualityEstimationClientImpl(serviceUrl));
    }

    public static void setDefaultUserId(String userId) {
        defaultUserId = userId;
    }

    public static void setDefaultPassword(String password) {
        defaultPassword = password;
    }

    private static <T extends ServiceClient> T setup(T client) {
        if (defaultUserId != null) {
            client.setUserId(defaultUserId);
        }
        if (defaultPassword != null) {
            client.setPassword(defaultPassword);
        }
        return client;
    }

    static {
        logger = Logger.getLogger(ClientFactory.class.getName());
        converter = new Converter();
        converter.addTransformerConversion((Transformer)new StringToPartOfSpeechTransformer());
        converter.addTransformerConversion((Transformer)new StringToDictMatchingMethodTransformer());
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException e) {
            logger.warning("failed to set system property \"java.net.useSystemProxies\"");
        }
        ProxySelectingAxisSocketFactory.install();
        ProxySelectingSecureAxisSocketFactory.install();
        PacUtil.setupDefaultProxySelector();
    }
}

