/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.ws_1_2.error;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.go.nict.langrid.commons.lang.StringUtil;

public enum LangridError {
    E000,
    E001,
    E002,
    E050,
    E051,
    E052,
    E053,
    E054,
    E055,
    E056,
    E057,
    E058,
    E059,
    E060,
    E061,
    E062,
    E063,
    E150,
    E153,
    E154,
    E155,
    E156,
    E157,
    E450,
    E451,
    E1250,
    E1251,
    E1252,
    E1350,
    E1351;

    private static ResourceBundle defaultBundle;
    private static Set<String> descriptionPreferredClasses;

    public String getMessage(Throwable exception, Locale locale) {
        return this.getMessage(exception, this.getResourceBundle(locale));
    }

    public String getMessage(Throwable exception) {
        return this.getMessage(exception, defaultBundle);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("jp.go.nict.langrid.client.ws_1_2.error.messages", locale);
    }

    private String getMessage(Throwable exception, ResourceBundle bundle) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String template = bundle.getString(this.name());
        String varPattern = "\\$\\{([^\\}]*)\\}";
        Matcher m = Pattern.compile(varPattern).matcher(template);
        ArrayList<String> values = new ArrayList<String>();
        while (m.find()) {
            String description;
            String param = m.group(1);
            if (param.equals("message") && descriptionPreferredClasses.contains(exception.getClass().getName()) && (description = this.getDescription(exception)) != null) {
                values.add(description);
                continue;
            }
            try {
                Method method = clazz.getMethod("get" + param.substring(0, 1).toUpperCase() + param.substring(1), new Class[0]);
                Object value = method.invoke((Object)exception, new Object[0]);
                if (value instanceof String[]) {
                    values.add(StringUtil.join((String[])((String[])value), (String)","));
                    continue;
                }
                if (value != null) {
                    values.add(value.toString());
                    continue;
                }
                values.add("(null)");
            }
            catch (IllegalAccessException e) {
                values.add(e.getMessage());
            }
            catch (InvocationTargetException e) {
                values.add(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                values.add(e.getMessage());
            }
        }
        return String.format(Pattern.compile(varPattern).matcher(template).replaceAll("%s"), values.toArray(new String[0]));
    }

    private String getDescription(Object object) {
        try {
            return (String)object.getClass().getMethod("getDescription", new Class[0]).invoke(object, new Object[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static {
        defaultBundle = ResourceBundle.getBundle("jp.go.nict.langrid.client.ws_1_2.error.messages");
        descriptionPreferredClasses = new HashSet<String>();
        descriptionPreferredClasses.add("jp.go.nict.langrid.ws_1_2.LangridException");
    }
}

