/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.ws_1_2.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import jp.go.nict.langrid.client.ws_1_2.ServiceClient;
import jp.go.nict.langrid.client.ws_1_2.impl.AxisStubUtil;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.cs.binding.BindingNode;
import jp.go.nict.langrid.commons.cs.binding.DynamicBindingUtil;
import jp.go.nict.langrid.commons.cs.calltree.CallNode;
import jp.go.nict.langrid.commons.cs.calltree.CallTreeUtil;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.ws.soap.SoapHeaderRpcHeadersAdapter;
import jp.go.nict.langrid.service_1_2.transformer.StringToDictMatchingMethodTransformer;
import jp.go.nict.langrid.service_1_2.transformer.StringToPartOfSpeechTransformer;
import org.apache.axis.Message;
import org.apache.axis.client.Stub;

public class ServiceClientAxisStubAdapter
implements ServiceClient,
Serializable {
    private Stub stub;
    private boolean headerModified;
    private Collection<BindingNode> treeBindings = new ArrayList<BindingNode>();
    private Hashtable<String, String> httpHeaders = new Hashtable();
    private String lastName;
    private String lastCopyright;
    private String lastLicense;
    private Collection<CallNode> lastCallTree = new ArrayList<CallNode>();
    private static Converter converter = new Converter();
    private static final long serialVersionUID = 5708773854342542725L;

    public ServiceClientAxisStubAdapter(Stub stub, URL url) {
        this.stub = stub;
        AxisStubUtil.setUrl(stub, url);
    }

    @Override
    public void setUserId(String userId) {
        AxisStubUtil.setUserName(this.stub, userId);
    }

    @Override
    public void setPassword(String password) {
        AxisStubUtil.setPassword(this.stub, password);
    }

    @Override
    public Collection<BindingNode> getTreeBindings() {
        this.headerModified = true;
        return this.treeBindings;
    }

    @Override
    public void addRequestHeader(String name, String value) {
        this.headerModified = true;
        this.httpHeaders.put(name, value);
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getLastCopyrightInfo() {
        return this.lastCopyright;
    }

    @Override
    public String getLastLicenseInfo() {
        return this.lastLicense;
    }

    @Override
    public Collection<CallNode> getLastCallTree() {
        return this.lastCallTree;
    }

    public void preInvoke() {
        if (this.headerModified) {
            AxisStubUtil.setMimeHeaders(this.stub, this.httpHeaders.entrySet());
            AxisStubUtil.setSoapHeaders(this.stub, this.getMessageHeader());
            this.headerModified = false;
        }
    }

    public void postInvoke() {
        Message message = null;
        if (this.stub._getCall() != null) {
            message = this.stub._getCall().getMessageContext().getResponseMessage();
        }
        if (message == null) {
            this.lastName = null;
            this.lastCopyright = null;
            this.lastLicense = null;
            this.lastCallTree = null;
        } else {
            MimeHeaders headers = message.getMimeHeaders();
            this.lastName = this.getJoinedAndDecodedHeader(headers, "X-LanguageGrid-ServiceName", "<br>");
            this.lastCopyright = this.getJoinedAndDecodedHeader(headers, "X-LanguageGrid-ServiceCopyright", "<br>");
            this.lastLicense = this.getJoinedAndDecodedHeader(headers, "X-LanguageGrid-ServiceLicense", "<br>");
            try {
                this.lastCallTree = CallTreeUtil.extractNodes((Iterable)new SoapHeaderRpcHeadersAdapter(message.getSOAPHeader()));
            }
            catch (SOAPException sOAPException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private Iterable<Map.Entry<QName, Object>> getMessageHeader() {
        HashMap<QName, String> bindings = new HashMap<QName, String>();
        String tvalue = DynamicBindingUtil.encodeTree(this.treeBindings);
        bindings.put(new QName("http://langrid.nict.go.jp/process/binding/tree", "binding"), tvalue);
        return bindings.entrySet();
    }

    private String getJoinedAndDecodedHeader(MimeHeaders headers, String headerName, String separator) {
        String[] values = headers.getHeader(headerName);
        if (values != null) {
            try {
                return URLDecoder.decode(StringUtil.join((String[])values, (String)separator), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static {
        converter.addTransformerConversion((Transformer)new StringToPartOfSpeechTransformer());
        converter.addTransformerConversion((Transformer)new StringToDictMatchingMethodTransformer());
    }
}

