/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.jsonrpc;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import jp.go.nict.langrid.client.AsyncInvocationHandler;
import jp.go.nict.langrid.client.AuthMethod;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.RequestAttributes;
import jp.go.nict.langrid.client.ResponseAttributes;
import jp.go.nict.langrid.client.RpcRequestAttributes;
import jp.go.nict.langrid.client.RpcResponseAttributes;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.io.DuplicatingInputStream;
import jp.go.nict.langrid.commons.io.DuplicatingOutputStream;
import jp.go.nict.langrid.commons.io.EmptyInputStream;
import jp.go.nict.langrid.commons.net.HttpURLConnectionUtil;
import jp.go.nict.langrid.commons.rpc.RpcFault;
import jp.go.nict.langrid.commons.rpc.RpcFaultUtil;
import jp.go.nict.langrid.commons.rpc.json.JsonRpcResponse;
import jp.go.nict.langrid.commons.rpc.json.JsonRpcUtil;
import jp.go.nict.langrid.commons.util.concurrent.DaemonThreadFactory;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONException;

public class JsonRpcClientFactory
implements ClientFactory {
    private ExecutorService es;
    private OutputStream requestDumpStream;
    private OutputStream responseDumpStream;
    private static Converter converter = new Converter();

    @Override
    public <T> T create(Class<T> interfaceClass, URL url) {
        return this.create(interfaceClass, new JsonRpcInvocationHandler(url));
    }

    @Override
    public <T> T create(Class<T> interfaceClass, URL url, String userId, String password) {
        JsonRpcInvocationHandler h = new JsonRpcInvocationHandler(url);
        h.reqAttrs.setUserId(userId);
        h.reqAttrs.setPassword(password);
        return this.create(interfaceClass, h);
    }

    public <T> T createAsync(Class<T> interfaceClass, URL url) {
        return this.createAsync(interfaceClass, new JsonRpcAsyncInvocationHandler(url));
    }

    public <T> T createAsync(Class<T> interfaceClass, URL url, String userId, String password) {
        JsonRpcAsyncInvocationHandler h = new JsonRpcAsyncInvocationHandler(url);
        h.getReqAttrs().setUserId(userId);
        h.getReqAttrs().setPassword(password);
        return this.createAsync(interfaceClass, h);
    }

    private <T> T create(Class<T> interfaceClass, InvocationHandler handler) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass, RequestAttributes.class, ResponseAttributes.class}, handler));
    }

    private <T> T createAsync(Class<T> interfaceClass, AsyncInvocationHandler handler) {
        return interfaceClass.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceClass, RequestAttributes.class, ResponseAttributes.class, AsyncInvocationHandler.class}, (InvocationHandler)handler));
    }

    public void setRequestDumpStream(OutputStream stream) {
        this.requestDumpStream = stream;
    }

    public void setResponseDumpStream(OutputStream stream) {
        this.responseDumpStream = stream;
    }

    private synchronized ExecutorService getExecutorService() {
        if (this.es == null) {
            this.es = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new DaemonThreadFactory());
        }
        return this.es;
    }

    class JsonRpcAsyncInvocationHandler
    extends JsonRpcInvocationHandler
    implements AsyncInvocationHandler {
        private Future lastFuture;

        public JsonRpcAsyncInvocationHandler(URL url) {
            super(url);
        }

        @Override
        public <T> Future<T> getLastFuture() {
            return this.lastFuture;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            Class<?> clz = method.getDeclaringClass();
            if (clz.equals(RequestAttributes.class)) {
                return method.invoke((Object)this.getReqAttrs(), args);
            }
            if (clz.equals(ResponseAttributes.class)) {
                return method.invoke((Object)this.getResAttrs(), args);
            }
            if (clz.equals(AsyncInvocationHandler.class)) {
                return method.invoke((Object)this, args);
            }
            this.lastFuture = JsonRpcClientFactory.this.getExecutorService().submit(new Callable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() throws Exception {
                    HttpURLConnection con = JsonRpcAsyncInvocationHandler.this.openConnection();
                    try {
                        JsonRpcAsyncInvocationHandler.this.writeRequest(con, method, args);
                        int sts = con.getResponseCode();
                        if (sts == 404) {
                            throw new FileNotFoundException(JsonRpcAsyncInvocationHandler.this.getUrl().toString());
                        }
                        Object object = JsonRpcAsyncInvocationHandler.this.readResponse(con, method.getReturnType());
                        return object;
                    }
                    finally {
                        JsonRpcAsyncInvocationHandler.this.closeConnection(con);
                    }
                }
            });
            return null;
        }
    }

    class JsonRpcInvocationHandler
    implements InvocationHandler {
        private int nc = 1;
        private URL url;
        private RpcRequestAttributes reqAttrs = new RpcRequestAttributes();
        private RpcResponseAttributes resAttrs = new RpcResponseAttributes();

        public JsonRpcInvocationHandler(URL url) {
            this.url = url;
        }

        public JsonRpcInvocationHandler(URL url, int connectionTimeout, int readTimeout) {
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }

        public RpcRequestAttributes getReqAttrs() {
            return this.reqAttrs;
        }

        public RpcResponseAttributes getResAttrs() {
            return this.resAttrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> clz = method.getDeclaringClass();
            if (clz.equals(RequestAttributes.class)) {
                return method.invoke((Object)this.reqAttrs, args);
            }
            if (clz.equals(ResponseAttributes.class)) {
                return method.invoke((Object)this.resAttrs, args);
            }
            HttpURLConnection con = this.openConnection();
            try {
                con.setUseCaches(false);
                con.setDoOutput(true);
                this.writeRequest(con, method, args);
                int sts = con.getResponseCode();
                if (sts == 404) {
                    throw new FileNotFoundException(this.url.toString());
                }
                Object object = this.readResponse(con, method.getGenericReturnType());
                return object;
            }
            finally {
                this.closeConnection(con);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HttpURLConnection openConnection() throws IOException {
            AuthMethod am = this.reqAttrs.getAuthMethod();
            if (am != null && am.equals((Object)AuthMethod.DIGEST) && this.reqAttrs.getUserId() != null) {
                Map param = null;
                HttpURLConnection con1 = (HttpURLConnection)this.url.openConnection();
                try {
                    param = HttpURLConnectionUtil.parseWwwAuthenticateHeader((String)con1.getHeaderField("WWW-Authenticate"));
                }
                finally {
                    con1.disconnect();
                }
                HttpURLConnection con2 = (HttpURLConnection)this.url.openConnection();
                con2.setRequestProperty("Authorization", HttpURLConnectionUtil.createDigestAuthValue((Map)param, (String)"POST", (String)this.url.getPath(), (String)this.reqAttrs.getUserId(), (String)this.reqAttrs.getPassword(), (int)this.nc++));
                return con2;
            }
            return (HttpURLConnection)this.url.openConnection();
        }

        protected void closeConnection(HttpURLConnection con) {
            con.disconnect();
        }

        protected void writeRequest(HttpURLConnection con, final Method method, final Object[] args) throws IOException {
            con.setRequestProperty("Accept", "application/json-rpc");
            con.setRequestProperty("Content-type", "application/json-rpc");
            con.setRequestProperty("X-Langrid-Protocol", "JSON_RPC");
            this.reqAttrs.setUpConnection(con);
            OutputStream os = HttpURLConnectionUtil.processWriteRequest((HttpURLConnection)con, (boolean)this.reqAttrs.isRequestContentCompression(), (int)this.reqAttrs.getRequestContentComporessionThreashold(), (String)this.reqAttrs.getRequestContentCompressionAlgorithm(), (HttpURLConnectionUtil.WriteProcess)new HttpURLConnectionUtil.WriteProcess(){

                public void write(OutputStream os) throws IOException {
                    if (JsonRpcClientFactory.this.requestDumpStream != null) {
                        os = new DuplicatingOutputStream(os, JsonRpcClientFactory.this.requestDumpStream);
                    }
                    JSON.encode((Object)JsonRpcUtil.createRequest(JsonRpcInvocationHandler.this.reqAttrs.getAllRpcHeaders(), (Method)method, (Object[])args), (OutputStream)os);
                }
            });
            os.flush();
        }

        protected Object readResponse(HttpURLConnection con, Type returnType) throws IOException, ParseException, Exception {
            InputStream is = HttpURLConnectionUtil.openResponseStream((HttpURLConnection)con);
            if (is == null) {
                is = new EmptyInputStream();
            }
            if (JsonRpcClientFactory.this.responseDumpStream != null) {
                is = new DuplicatingInputStream(is, JsonRpcClientFactory.this.responseDumpStream);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            is = new DuplicatingInputStream(is, (OutputStream)baos);
            JsonRpcResponse ret = null;
            try {
                ret = (JsonRpcResponse)JSON.decode((InputStream)is, JsonRpcResponse.class);
            }
            catch (JSONException e) {
                throw new RuntimeException("Parse error for URL:[" + con.getURL() + "], JSON:" + baos.toString("UTF-8"), e);
            }
            if (ret.getHeaders() != null) {
                this.resAttrs.loadAttributes(con, Arrays.asList(ret.getHeaders()));
            }
            if (ret.getError() != null) {
                throw RpcFaultUtil.rpcFaultToThrowable((RpcFault)ret.getError());
            }
            return converter.convert(ret.getResult(), returnType);
        }
    }
}

