/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client;

import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import jp.go.nict.langrid.client.AuthMethod;
import jp.go.nict.langrid.client.RequestAttributes;
import jp.go.nict.langrid.commons.cs.binding.BindingNode;
import jp.go.nict.langrid.commons.cs.binding.DynamicBindingUtil;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.ws.BasicAuthUtil;

public class RpcRequestAttributes
implements RequestAttributes {
    private String userId;
    private String password;
    private AuthMethod authMethod;
    private int connectTimeoutMillis = -1;
    private int timeoutMillis = -1;
    private boolean requestContentCompression = false;
    private String requestContentCompressionAlgorithm = "deflate";
    private int requestContentComporessionThreashold = 1024;
    private boolean responseContentCompression = true;
    private Map<String, Object> httpHeaders = new HashMap<String, Object>();
    private boolean mightBeModified = true;
    private List<BindingNode> bindings = new ArrayList<BindingNode>();
    private Map<QName, Object> rpcHeaders = new HashMap<QName, Object>();
    private String bindingsValue;
    private String userParam;

    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public void setAuthMethod(AuthMethod method) {
        this.authMethod = method;
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.connectTimeoutMillis = timeoutMillis;
    }

    @Override
    public void setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public boolean isRequestContentCompression() {
        return this.requestContentCompression;
    }

    @Override
    public void setRequestContentCompression(boolean requestContentCompression) {
        this.requestContentCompression = requestContentCompression;
    }

    public String getRequestContentCompressionAlgorithm() {
        return this.requestContentCompressionAlgorithm;
    }

    @Override
    public void setRequestContentCompressionAlgorithm(String algorithm) {
        this.requestContentCompressionAlgorithm = algorithm;
    }

    public boolean isResponseContentCompression() {
        return this.responseContentCompression;
    }

    public int getRequestContentComporessionThreashold() {
        return this.requestContentComporessionThreashold;
    }

    @Override
    public void setRequestContentCompressionThreashold(int bytes) {
        this.requestContentComporessionThreashold = bytes;
    }

    @Override
    public void setResponseContentCompression(boolean responseContentCompression) {
        this.responseContentCompression = responseContentCompression;
    }

    @Override
    public void addRequestMimeHeader(String name, String value) {
        this.mightBeModified = true;
        this.httpHeaders.put(name, value);
    }

    @Override
    public void addRequestMimeHeaders(Map<String, Object> headers) {
        this.mightBeModified = true;
        this.httpHeaders.putAll(headers);
    }

    public Map<String, Object> getRequestMimeHeaders() {
        this.mightBeModified = true;
        return this.httpHeaders;
    }

    @Override
    public void addRequestRpcHeader(String namespace, String name, String value) {
        this.mightBeModified = true;
        this.rpcHeaders.put(new QName(namespace, name), value);
    }

    @Override
    public void addRequestRpcHeaders(Map<QName, Object> headers) {
        this.mightBeModified = true;
        this.rpcHeaders.putAll(headers);
    }

    @Override
    public Collection<BindingNode> getTreeBindings() {
        this.mightBeModified = true;
        return this.bindings;
    }

    public void setUpConnection(HttpURLConnection con) {
        if (this.connectTimeoutMillis != -1) {
            con.setConnectTimeout(this.connectTimeoutMillis);
        }
        if (this.timeoutMillis != -1) {
            con.setReadTimeout(this.timeoutMillis);
        }
        if (this.responseContentCompression) {
            con.addRequestProperty("accept-encoding", "gzip,deflate,identity");
        }
        if (this.userId != null) {
            if (this.password == null) {
                this.password = "";
            }
            con.addRequestProperty("Authorization", BasicAuthUtil.encode((String)this.userId, (String)this.password));
        }
        if (this.userParam != null) {
            con.addRequestProperty("X-ServiceGrid-ServiceInvocation-UserParam", this.userParam);
        }
        for (Map.Entry<String, Object> e : this.httpHeaders.entrySet()) {
            con.addRequestProperty(e.getKey(), e.getValue().toString());
        }
    }

    public Collection<RpcHeader> getAllRpcHeaders() {
        if (this.mightBeModified) {
            this.bindingsValue = DynamicBindingUtil.encodeTree(this.bindings);
            this.mightBeModified = false;
        }
        ArrayList<RpcHeader> ret = new ArrayList<RpcHeader>();
        for (Map.Entry<QName, Object> entry : this.rpcHeaders.entrySet()) {
            ret.add(new RpcHeader(entry.getKey().getNamespaceURI(), entry.getKey().getLocalPart(), entry.getValue().toString()));
        }
        if (this.bindingsValue != null && !this.bindingsValue.equals("[]")) {
            ret.add(new RpcHeader("http://langrid.nict.go.jp/process/binding/tree", "binding", this.bindingsValue));
        }
        return ret;
    }

    public String getUserParam() {
        return this.userParam;
    }

    @Override
    public void setUserParam(String param) {
        this.userParam = param;
    }
}

