/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client;

import java.net.HttpURLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.client.ResponseAttributes;
import jp.go.nict.langrid.commons.cs.calltree.CallNode;
import jp.go.nict.langrid.commons.cs.calltree.CallTreeUtil;
import jp.go.nict.langrid.commons.rpc.RpcFault;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.ws.MimeHeaders;

public class RpcResponseAttributes
implements ResponseAttributes {
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private List<RpcHeader> rpcHeaders = new ArrayList<RpcHeader>();
    private RpcFault rpcFault;
    private String serviceName;
    private String copyright;
    private String licenseInfo;
    private List<CallNode> callTree = new ArrayList<CallNode>();

    public void loadAttributes(HttpURLConnection con, Collection<RpcHeader> headers) throws ParseException {
        Map<String, List<String>> mheaders = con.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : mheaders.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            for (String value : entry.getValue()) {
                this.mimeHeaders.addHeader(name, value);
            }
        }
        this.serviceName = RpcResponseAttributes.join(mheaders.get("X-LanguageGrid-ServiceName"));
        this.copyright = RpcResponseAttributes.join(mheaders.get("X-LanguageGrid-ServiceCopyright"));
        this.licenseInfo = RpcResponseAttributes.join(mheaders.get("X-LanguageGrid-ServiceLicense"));
        this.loadAttributes(headers);
    }

    public void loadAttributes(Collection<RpcHeader> headers) throws ParseException {
        this.rpcHeaders.addAll(headers);
        this.callTree = CallTreeUtil.extractNodes(headers);
    }

    private static String join(List<String> values) {
        if (values == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : values) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(s);
        }
        return b.toString();
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getLicenseInfo() {
        return this.licenseInfo;
    }

    @Override
    public Collection<CallNode> getCallTree() {
        return this.callTree;
    }

    @Override
    public MimeHeaders getResponseMimeHeaders() {
        return this.mimeHeaders;
    }

    @Override
    public Iterable<RpcHeader> getResponseRpcHeaders() {
        return this.rpcHeaders;
    }

    @Override
    public RpcFault getResponseRpcFault() {
        return this.rpcFault;
    }

    public void setRpcFault(RpcFault rpcFault) {
        this.rpcFault = rpcFault;
    }
}

