/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.junit.Assert;

public class AssertUtil {
    public static <T> void assertArrayEquals(T[] expected, T[] actual) {
        Assert.assertEquals((String)(Arrays.toString(actual) + " must be equals " + Arrays.toString(expected)), (long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual) {
        Assert.assertEquals((String)"array size is different.", (long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)(i + "th element is different"), (long)expected[i], (long)actual[i]);
        }
    }

    public static <T> void assertArrayEqualsIgnoreOrder(T[] expected, T[] actual) {
        AssertUtil.assertArrayEqualsIgnoreOrder(null, expected, actual);
    }

    public static <T> void assertArrayEqualsIgnoreOrder(String message, T[] expected, T[] actual) {
        Integer n;
        Integer n2;
        Integer c;
        Assert.assertEquals((String)AssertUtil.getMessage(message, String.format("expected %d but was %d.", expected.length, actual.length)), (long)expected.length, (long)actual.length);
        HashMap<T, Integer> exp = new HashMap<T, Integer>();
        for (T e : expected) {
            c = (Integer)exp.get(e);
            if (c != null) {
                n2 = c;
                n = c = Integer.valueOf(c + 1);
            } else {
                c = 1;
            }
            exp.put(e, c);
        }
        for (T a : actual) {
            c = (Integer)exp.get(a);
            Assert.assertNotNull((String)AssertUtil.getMessage(message, a + " is redundant."), (Object)c);
            Assert.assertTrue((c > 0 ? 1 : 0) != 0);
            n2 = c;
            n = c = Integer.valueOf(c - 1);
            if (c == 0) {
                exp.remove(a);
                continue;
            }
            exp.put(a, c);
        }
        if (exp.size() != 0) {
            StringBuilder b = new StringBuilder();
            for (Object e : exp.keySet()) {
                b.append(e);
                b.append(",");
            }
            Assert.fail((String)AssertUtil.getMessage(message, b.toString() + " is missing."));
        }
    }

    public static <T> boolean assertArrayEqualsIgnoreOrder(T[] value1, T[] value2, Class<T> clazz, String equalsMethodName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method m = null;
        try {
            m = clazz.getMethod(equalsMethodName, clazz);
        }
        catch (NoSuchMethodException e) {
            m = clazz.getMethod(equalsMethodName, Object.class);
        }
        LinkedList<T> s1 = new LinkedList<T>();
        for (T v : value1) {
            s1.add(v);
        }
        for (T v : value2) {
            Iterator i2 = s1.iterator();
            boolean found = false;
            while (i2.hasNext()) {
                if (!((Boolean)m.invoke(v, i2.next())).booleanValue()) continue;
                i2.remove();
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return s1.size() == 0;
    }

    public static <T> boolean assertEqualsIgnoreOrder(Collection<T> value1, Collection<T> value2) {
        HashSet<T> s1 = new HashSet<T>();
        for (T v : value1) {
            s1.add(v);
        }
        HashSet<T> s2 = new HashSet<T>();
        for (T v : value2) {
            s2.add(v);
        }
        return s1.equals(s2);
    }

    public static <T> boolean assertEqualsIgnoreOrder(Collection<T> value1, Collection<T> value2, Class<T> clazz, String equalsMethodName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method m = null;
        try {
            m = clazz.getMethod(equalsMethodName, clazz);
        }
        catch (NoSuchMethodException e) {
            m = clazz.getMethod(equalsMethodName, Object.class);
        }
        return AssertUtil.assertEqualsIgnoreOrder(value1, value2, m);
    }

    public static <T> boolean assertEqualsIgnoreOrder(Collection<T> value1, Collection<T> value2, Method equalsMethod) throws IllegalAccessException, InvocationTargetException {
        if (!equalsMethod.getReturnType().equals(Boolean.TYPE)) {
            return false;
        }
        LinkedList<T> s1 = new LinkedList<T>();
        for (T v : value1) {
            s1.add(v);
        }
        for (T v : value2) {
            Iterator i2 = s1.iterator();
            boolean found = false;
            while (i2.hasNext()) {
                if (!((Boolean)equalsMethod.invoke(v, i2.next())).booleanValue()) continue;
                i2.remove();
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return s1.size() == 0;
    }

    private static String getMessage(String message, String submessage) {
        if (message == null) {
            return submessage;
        }
        return message + "[" + submessage + "]";
    }
}

