/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import jp.go.nict.langrid.commons.test.MultithreadRunnable;
import jp.go.nict.langrid.commons.test.SinglethreadRunnable;
import jp.go.nict.langrid.commons.test.SinglethreadRunnableFactory;

public class MultithreadRunner {
    private int count;
    private long deltaTimeMillis;
    private List<Exception> exceptions = Collections.synchronizedList(new ArrayList());

    public MultithreadRunner(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public long getDeltaTimeMillis() {
        return this.deltaTimeMillis;
    }

    public void run(final MultithreadRunnable runnable) throws InterruptedException {
        this.run(new SinglethreadRunnableFactory(){

            @Override
            public SinglethreadRunnable create() throws Exception {
                return runnable;
            }
        });
    }

    public void run(SinglethreadRunnableFactory factory) throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch endSignal = new CountDownLatch(this.count);
        for (int i = 0; i < this.count; ++i) {
            SinglethreadRunnable runnable = null;
            try {
                runnable = factory.create();
            }
            catch (Exception e) {
                this.exceptions.add(e);
                continue;
            }
            Thread t = new Thread(new RunnableRunnable(runnable, startSignal, endSignal, this.exceptions));
            t.setName(runnable.getClass().getName() + "-" + i);
            threads.add(t);
            t.start();
        }
        long st = System.currentTimeMillis();
        startSignal.countDown();
        endSignal.await();
        for (Thread t : threads) {
            t.join();
        }
        this.deltaTimeMillis = System.currentTimeMillis() - st;
    }

    public Collection<Exception> getExceptions() {
        return this.exceptions;
    }

    private static class RunnableRunnable
    implements Runnable {
        private SinglethreadRunnable runnable;
        private CountDownLatch startSignal;
        private CountDownLatch endSignal;
        private List<Exception> exceptions;

        public RunnableRunnable(SinglethreadRunnable runnable, CountDownLatch startSignal, CountDownLatch endSignal, List<Exception> exceptions) {
            this.runnable = runnable;
            this.startSignal = startSignal;
            this.endSignal = endSignal;
            this.exceptions = exceptions;
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                this.runnable.run();
            }
            catch (Exception e) {
                this.exceptions.add(e);
            }
            finally {
                this.endSignal.countDown();
            }
        }
    }
}

