/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.test;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.junit.Assert;

public class CollectionFixture<T> {
    private Collection<T> collection;
    private Iterator<T> it;

    public CollectionFixture(Collection<T> collection) {
        this.collection = collection;
        this.it = collection.iterator();
    }

    public CollectionFixture<T> assertHasNext() {
        Assert.assertTrue((boolean)this.it.hasNext());
        return this;
    }

    public CollectionFixture<T> assertNotHasNext() {
        Assert.assertFalse((boolean)this.it.hasNext());
        return this;
    }

    public CollectionFixture<T> assertSize(int expected) {
        Assert.assertEquals((long)expected, (long)this.collection.size());
        return this;
    }

    public CollectionFixture<T> assertNextEquals(T expected) {
        Assert.assertEquals(expected, this.it.next());
        return this;
    }

    public <U extends T> CollectionFixture<T> next(Consumer<U> c) {
        c.accept(this.it.next());
        return this;
    }
}

