/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.lang.ClassResource;
import jp.go.nict.langrid.commons.transformer.PassthroughTransformer;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class ClassResourceLoader {
    public static void load(Object instance) throws IOException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = instance.getClass();
        ClassResourceLoader.load(clazz, instance, clazz.getDeclaredFields());
    }

    public static <T> void load(T instance, Class<T> clazz) throws IOException, IllegalArgumentException, IllegalAccessException {
        ClassResourceLoader.load(clazz, instance, clazz.getDeclaredFields());
    }

    public static void load(Class<?> clazz) throws IOException, IllegalArgumentException, IllegalAccessException {
        ClassResourceLoader.load(clazz, clazz, clazz.getDeclaredFields());
    }

    private static final void load(Class<?> clazz, Object instance, Field[] fields) throws IOException, IllegalArgumentException, IllegalAccessException {
        for (Field f : fields) {
            InputStream is;
            ClassResource a = f.getAnnotation(ClassResource.class);
            if (a == null) continue;
            f.setAccessible(true);
            String name = a.path();
            if (name.length() == 0) {
                name = f.getName();
            }
            if ((is = clazz.getResourceAsStream(name)) == null) {
                throw new IOException("failed to find resource: " + name);
            }
            try {
                byte[] bytes = StreamUtil.readAsBytes(is);
                Class<?> c = a.converter();
                if (c.equals(PassthroughTransformer.class)) {
                    f.set(instance, bytes);
                    continue;
                }
                if (Transformer.class.isAssignableFrom(c)) {
                    f.set(instance, ((Transformer)c.newInstance()).transform(bytes));
                    continue;
                }
                throw new IllegalArgumentException("Unknown converter: " + c.getName());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                is.close();
            }
        }
    }
}

