/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.rpc.intf;

import java.lang.annotation.Annotation;
import jp.go.nict.langrid.commons.rpc.intf.Description;
import jp.go.nict.langrid.commons.rpc.intf.Descriptions;
import jp.go.nict.langrid.commons.rpc.intf.Method;
import jp.go.nict.langrid.commons.rpc.intf.Parameter;
import jp.go.nict.langrid.commons.rpc.intf.Service;
import jp.go.nict.langrid.commons.util.Trio;

public class RpcAnnotationUtil {
    public static String getServiceDescriptions(Class<?> clazz, String descriptionLanguage) {
        Description[] descriptionArray;
        Service sa = clazz.getAnnotation(Service.class);
        Descriptions ds = clazz.getAnnotation(Descriptions.class);
        Description de = clazz.getAnnotation(Description.class);
        String first = null;
        Description[] empty = new Description[]{};
        Description[][] descriptionArrayArray = new Description[3][];
        descriptionArrayArray[0] = sa != null ? sa.descriptions() : empty;
        Description[] descriptionArray2 = descriptionArrayArray[1] = ds != null ? ds.value() : empty;
        if (de != null) {
            Description[] descriptionArray3 = new Description[1];
            descriptionArray = descriptionArray3;
            descriptionArray3[0] = de;
        } else {
            descriptionArray = empty;
        }
        descriptionArrayArray[2] = descriptionArray;
        Description[][] descriptionArrayArray2 = descriptionArrayArray;
        int n = descriptionArrayArray2.length;
        for (int i = 0; i < n; ++i) {
            Description[] descs;
            for (Description d : descs = descriptionArrayArray2[i]) {
                if (d.lang().equals(descriptionLanguage)) {
                    return d.value();
                }
                if (first != null) continue;
                first = d.value();
            }
        }
        return first;
    }

    public static String getMethodDescription(java.lang.reflect.Method intfMethod, java.lang.reflect.Method implMethod, String descriptionLanguage) {
        String first = null;
        Description[] empty = new Description[]{};
        for (java.lang.reflect.Method m : new java.lang.reflect.Method[]{implMethod, intfMethod}) {
            Description[] descriptionArray;
            Method ma = m.getAnnotation(Method.class);
            Descriptions ds = m.getAnnotation(Descriptions.class);
            Description de = m.getAnnotation(Description.class);
            Description[][] descriptionArrayArray = new Description[3][];
            descriptionArrayArray[0] = ma != null ? ma.descriptions() : empty;
            Description[] descriptionArray2 = descriptionArrayArray[1] = ds != null ? ds.value() : empty;
            if (de != null) {
                Description[] descriptionArray3 = new Description[1];
                descriptionArray = descriptionArray3;
                descriptionArray3[0] = de;
            } else {
                descriptionArray = empty;
            }
            descriptionArrayArray[2] = descriptionArray;
            Description[][] descriptionArrayArray2 = descriptionArrayArray;
            int n = descriptionArrayArray2.length;
            for (int i = 0; i < n; ++i) {
                Description[] descs;
                for (Description d : descs = descriptionArrayArray2[i]) {
                    if (d.lang().equals(descriptionLanguage)) {
                        return d.value();
                    }
                    if (first != null) continue;
                    first = d.value();
                }
            }
        }
        return first;
    }

    public static int getMethodMaxReturnObjectDepth(java.lang.reflect.Method method) {
        Method ma = method.getAnnotation(Method.class);
        if (ma == null) {
            return 4;
        }
        return ma.maxReturnObjectDepth();
    }

    public static Trio<String, String, String>[] getParameterInfo(java.lang.reflect.Method intfMethod, java.lang.reflect.Method implMethod, String descriptionLanguage) {
        Annotation[][] implAnnots = implMethod.getParameterAnnotations();
        Annotation[][] intfAnnots = intfMethod.getParameterAnnotations();
        int n = implAnnots.length;
        Trio[] ret = new Trio[n];
        for (int i = 0; i < n; ++i) {
            String name = null;
            String sample = null;
            String desc = null;
            for (Annotation a : implAnnots[i]) {
                if (a instanceof Parameter) {
                    Parameter p = (Parameter)a;
                    name = p.name();
                    sample = p.sample();
                    desc = RpcAnnotationUtil.getDescription(p.descriptions(), descriptionLanguage);
                    continue;
                }
                if (a instanceof Description) {
                    if (desc != null) continue;
                    desc = ((Description)a).value();
                    continue;
                }
                if (!(a instanceof Descriptions) || desc != null) continue;
                desc = RpcAnnotationUtil.getDescription(((Descriptions)a).value(), descriptionLanguage);
            }
            boolean descFound = desc != null;
            for (Annotation a : intfAnnots[i]) {
                if (a instanceof Parameter) {
                    Parameter p = (Parameter)a;
                    if (name == null) {
                        name = p.name();
                    }
                    if (sample == null) {
                        sample = p.sample();
                    }
                    if (descFound) continue;
                    desc = RpcAnnotationUtil.getDescription(p.descriptions(), descriptionLanguage);
                    continue;
                }
                if (a instanceof Description) {
                    if (desc != null) continue;
                    desc = ((Description)a).value();
                    continue;
                }
                if (!(a instanceof Descriptions) || desc != null) continue;
                desc = RpcAnnotationUtil.getDescription(((Descriptions)a).value(), descriptionLanguage);
            }
            if (name == null) {
                name = "";
            }
            if (sample == null) {
                sample = "";
            }
            if (desc == null) {
                desc = "";
            }
            ret[i] = Trio.create(name, sample, desc);
        }
        return ret;
    }

    public static String getDescription(Description[] descs, String lang) {
        if (descs.length == 0) {
            return null;
        }
        Description target = null;
        for (Description desc : descs) {
            if (!desc.lang().equals(lang)) continue;
            target = desc;
            break;
        }
        if (target != null) {
            return target.value();
        }
        return descs[0].value();
    }
}

