/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import jp.go.nict.langrid.commons.runner.MultithreadRunnable;
import jp.go.nict.langrid.commons.runner.RunException;
import jp.go.nict.langrid.commons.runner.SinglethreadRunnable;
import jp.go.nict.langrid.commons.runner.SinglethreadRunnableFactory;
import jp.go.nict.langrid.commons.runner.StatusReporter;

public class MultithreadRunner {
    private StatusReporter reporter;
    private AtomicInteger done = new AtomicInteger();
    private AtomicInteger fault = new AtomicInteger();
    private AtomicInteger count = new AtomicInteger();
    private int threadCount;
    private int retryCount;
    private int retryWaitMinMillis = 3000;
    private int retryWaitRangeMillis = 2000;
    private long deltaTimeMillis;
    private List<Exception> exceptions = Collections.synchronizedList(new ArrayList());

    public MultithreadRunner(int threadCount, int retryCount, StatusReporter reporter) {
        this.threadCount = threadCount;
        this.retryCount = retryCount;
        this.reporter = reporter;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getDeltaTimeMillis() {
        return this.deltaTimeMillis;
    }

    public void runAndWait(final MultithreadRunnable runnable) throws InterruptedException {
        this.runAndWait(new SinglethreadRunnableFactory(){

            @Override
            public SinglethreadRunnable create() throws Exception {
                return runnable;
            }
        });
    }

    public void runAndWait(SinglethreadRunnableFactory factory) throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch endSignal = new CountDownLatch(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            SinglethreadRunnable runnable = null;
            try {
                runnable = factory.create();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            String name = runnable.getClass().getName() + "-t" + i;
            Thread t = new Thread(this.createRunnable(name, runnable, startSignal, endSignal, this.exceptions));
            t.setName(name);
            threads.add(t);
            t.start();
        }
        long st = System.currentTimeMillis();
        this.reporter.start();
        startSignal.countDown();
        endSignal.await();
        for (Thread t : threads) {
            t.join();
        }
        this.deltaTimeMillis = System.currentTimeMillis() - st;
        this.reporter.end(this.done.intValue(), this.fault.intValue());
    }

    public int getRetryWaitMinMillis() {
        return this.retryWaitMinMillis;
    }

    public void setRetryWaitMinMillis(int retryWaitMinMillis) {
        this.retryWaitMinMillis = retryWaitMinMillis;
    }

    public int getRetryWaitRangeMillis() {
        return this.retryWaitRangeMillis;
    }

    public void setRetryWaitRangeMillis(int retryWaitRangeMillis) {
        this.retryWaitRangeMillis = retryWaitRangeMillis;
    }

    public Collection<Exception> getExceptions() {
        return this.exceptions;
    }

    protected int getTotalCount() {
        return this.getThreadCount();
    }

    protected Runnable createRunnable(String name, SinglethreadRunnable runnable, CountDownLatch startSignal, CountDownLatch endSignal, List<Exception> exceptions) {
        return new RunnableRunnable(name, runnable, startSignal, endSignal, exceptions);
    }

    protected void done(long dt) {
        this.done.incrementAndGet();
        this.report(dt);
    }

    protected void fault(long dt) {
        this.fault.incrementAndGet();
        this.report(dt);
    }

    protected void fault(long dt, Exception e) {
        this.reporter.reportException(e);
        this.fault.incrementAndGet();
        this.report(dt);
    }

    private void report(long dt) {
        int current = this.count.incrementAndGet();
        if (current == 0) {
            return;
        }
        int total = this.getTotalCount();
        this.reporter.report(dt, this.done.intValue(), this.fault.intValue(), total);
    }

    private class RunnableRunnable
    implements Runnable {
        private String name;
        private SinglethreadRunnable runnable;
        private CountDownLatch startSignal;
        private CountDownLatch endSignal;
        private List<Exception> exceptions;

        public RunnableRunnable(String name, SinglethreadRunnable runnable, CountDownLatch startSignal, CountDownLatch endSignal, List<Exception> exceptions) {
            this.name = name;
            this.runnable = runnable;
            this.startSignal = startSignal;
            this.endSignal = endSignal;
            this.exceptions = exceptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startSignal.await();
                int c = 0;
                long s = System.currentTimeMillis();
                while (true) {
                    try {
                        this.runnable.run();
                        MultithreadRunner.this.done(System.currentTimeMillis() - s);
                    }
                    catch (Exception e) {
                        this.exceptions.add(new RunException("exception in " + this.name + " at " + (c + 1) + " try", e));
                        if (c == MultithreadRunner.this.retryCount) {
                            MultithreadRunner.this.fault(System.currentTimeMillis() - s, e);
                            break;
                        }
                        ++c;
                        Thread.sleep(Math.round(Math.random() * (double)MultithreadRunner.this.retryWaitRangeMillis + (double)MultithreadRunner.this.retryWaitMinMillis));
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                MultithreadRunner.this.fault(0L);
            }
            finally {
                this.endSignal.countDown();
            }
        }
    }
}

