/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.Method;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.transformer.TransformerUtil;

public class StringToEnumTransformer<T extends Enum<T>>
implements Transformer<String, T> {
    private Class<T> clazz;
    private Method valueOf;

    public StringToEnumTransformer(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.valueOf = clazz.getDeclaredMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T transform(String value) throws TransformationException {
        return (T)((Enum)TransformerUtil.convertWithStaticMethod(this.valueOf, value, this.clazz));
    }
}

