/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.ws.soap.SoapHeaderAdapter;
import jp.go.nict.langrid.commons.ws.soap.SoapHeaderElementAdapter;

public class RpcHeadersToSoapHeaderAdapter
extends SoapHeaderAdapter {
    private Collection<RpcHeader> headers;

    public RpcHeadersToSoapHeaderAdapter() {
        this.headers = new ArrayList<RpcHeader>();
    }

    public RpcHeadersToSoapHeaderAdapter(Collection<RpcHeader> headers) {
        this.headers = headers;
    }

    public Collection<RpcHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public Iterator<SOAPHeaderElement> examineAllHeaderElements() {
        final Iterator<RpcHeader> i = this.headers.iterator();
        return new Iterator<SOAPHeaderElement>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public SOAPHeaderElement next() {
                final RpcHeader h = (RpcHeader)i.next();
                return new SoapHeaderElementAdapter(){

                    @Override
                    public String getValue() {
                        return h.getValue();
                    }

                    @Override
                    public String getNamespaceURI() {
                        return h.getNamespace();
                    }

                    @Override
                    public String getNodeName() {
                        return h.getName();
                    }
                };
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public SOAPElement addChildElement(SOAPElement arg0) throws SOAPException {
        String uri = arg0.getNamespaceURI();
        if (uri == null) {
            return null;
        }
        String value = arg0.getValue();
        if (value == null) {
            value = arg0.getNodeValue();
        }
        if (value == null) {
            return null;
        }
        this.headers.add(new RpcHeader(uri, arg0.getLocalName(), value));
        return arg0;
    }
}

