/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.Converter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.util.Base64;

final class ArrayConverter
implements Converter {
    public static final ArrayConverter INSTANCE = new ArrayConverter();

    ArrayConverter() {
    }

    @Override
    public Object convert(JSON json, JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        Map src;
        if (value instanceof Map) {
            src = (Map)((Object)value);
            if (!(src instanceof SortedMap)) {
                src = new TreeMap(src);
            }
            value = src.values();
        }
        if (value instanceof Collection) {
            src = value;
            Object array = Array.newInstance(c.getComponentType(), src.size());
            Class<?> pc = c.getComponentType();
            Class<?> pt = t instanceof GenericArrayType ? ((GenericArrayType)t).getGenericComponentType() : pc;
            Iterator it = src.iterator();
            int i = 0;
            while (it.hasNext()) {
                context.enter(i);
                Array.set(array, i, json.postparse(context, it.next(), pc, pt));
                context.exit();
                ++i;
            }
            return array;
        }
        Class<?> ctype = c.getComponentType();
        if (value instanceof String) {
            if (Byte.TYPE.equals(ctype)) {
                return Base64.decode((String)((Object)value));
            }
            if (Character.TYPE.equals(ctype)) {
                return ((String)((Object)value)).toCharArray();
            }
        }
        Object array = Array.newInstance(ctype, 1);
        Class<?> pc = ctype;
        Class<?> pt = t instanceof GenericArrayType ? ((GenericArrayType)t).getGenericComponentType() : pc;
        context.enter(0);
        Array.set(array, 0, json.postparse(context, value, pc, pt));
        context.exit();
        return array;
    }
}

