/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.util.Map;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.Formatter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONHint;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.NullFormatter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.StringFormatter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.io.OutputSource;

final class MapFormatter
implements Formatter {
    public static final MapFormatter INSTANCE = new MapFormatter();

    MapFormatter() {
    }

    @Override
    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        Map map = (Map)o;
        JSONHint hint = context.getHint();
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        out.append('{');
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (key == null || (value = entry.getValue()) == src || context.isSuppressNull() && value == null) continue;
            if (count != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                for (int j = 0; j < context.getDepth() + 1; ++j) {
                    out.append('\t');
                }
            }
            StringFormatter.serialize(context, key.toString(), out);
            out.append(':');
            if (context.isPrettyPrint()) {
                out.append(' ');
            }
            context.enter(key, hint);
            value = json.preformatInternal(context, value);
            if (value == null) {
                NullFormatter.INSTANCE.format(json, context, src, value, out);
            } else if (hint == null) {
                if (value.getClass().equals(lastClass)) {
                    lastFormatter.format(json, context, src, value, out);
                } else {
                    lastFormatter = json.formatInternal(context, value, out);
                    lastClass = value.getClass();
                }
            } else {
                json.formatInternal(context, value, out);
            }
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            for (int j = 0; j < context.getDepth(); ++j) {
                out.append('\t');
            }
        }
        out.append('}');
        return true;
    }
}

