/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.codec;

import jp.go.nict.langrid.commons.codec.FileNameCodec;

public class WindowsFileNameCodec
extends FileNameCodec {
    @Override
    public String encode(String value) {
        if (value.equals(".")) {
            return this.sharpEncode('.');
        }
        if (value.equals("..")) {
            return this.sharpEncode('.') + this.sharpEncode('.');
        }
        char[] chars = value.toCharArray();
        StringBuilder b = new StringBuilder();
        int i = 0;
        if (chars.length >= 3) {
            String head = new String(chars, i, 3);
            if (head.equalsIgnoreCase("aux") || head.equalsIgnoreCase("con") || head.equalsIgnoreCase("nul") || head.equalsIgnoreCase("prn")) {
                if (chars.length >= 4) {
                    if (chars[3] == '.') {
                        this.sharpEncode(chars, i, 3, b);
                        i += 3;
                    }
                } else {
                    this.sharpEncode(chars, i, 3, b);
                    i += 3;
                }
            }
            if ((head.equalsIgnoreCase("lpt") || head.equalsIgnoreCase("com")) && chars.length >= 4 && Character.isDigit(chars[3])) {
                this.sharpEncode(chars, i, 3, b);
                i += 3;
            }
        }
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\"': 
                case '*': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    b.append(this.sharpEncode(c));
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public String decode(String value) {
        return this.decode(value, '#');
    }

    protected void sharpEncode(char[] chars, int start, int count, StringBuilder builder) {
        for (int i = start; i < start + count; ++i) {
            builder.append(String.format("#%02x", chars[i]));
        }
    }

    protected String sharpEncode(char c) {
        return String.format("#%02x", c);
    }
}

