/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class DocumentUtil {
    private static DocumentBuilderFactory defaultDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder defaultDocumentBuilder = DocumentUtil.newDocumentBuilder();
    private static Document defaultDocument = DocumentUtil.newDocument();
    private static TransformerFactory defaultTransformerFactory;
    private static Transformer defaultTransformer;
    private static Transformer defaultTextTransformer;
    private static XPathFactory defaultXPathFactory;
    private static XPath defaultXPath;

    public static Document newDocument() {
        return defaultDocumentBuilder.newDocument();
    }

    public static Document getDefaultDocument() {
        return defaultDocument;
    }

    public static DocumentBuilder newDocumentBuilder() {
        try {
            return defaultDocumentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static DocumentBuilder getDefaultDocumentBuilder() {
        return defaultDocumentBuilder;
    }

    public static String toString(Document document) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            defaultTextTransformer.transform(new DOMSource(document), new StreamResult(out));
            String string = new String(out.toByteArray(), "UTF-8");
            return string;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                out = null;
            }
        }
    }

    public static void writeDocument(Document document, OutputStream outputStream) throws TransformerException {
        defaultTransformer.transform(new DOMSource(document), new StreamResult(outputStream));
    }

    public static void writeDocument(Document document, Writer writer) throws TransformerException {
        defaultTransformer.transform(new DOMSource(document), new StreamResult(writer));
    }

    public static void writeDocument(Document document, StreamResult streamResult) throws TransformerException {
        defaultTransformer.transform(new DOMSource(document), streamResult);
    }

    public static TransformerFactory getDefaultTransformerFactory() {
        return defaultTransformerFactory;
    }

    public static Transformer getDefaultTransformer() {
        return defaultTransformer;
    }

    public static XPathFactory getDefaultXPathFactory() {
        return defaultXPathFactory;
    }

    public static XPath getDefaultXPath() {
        return defaultXPath;
    }

    static {
        try {
            defaultTransformerFactory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        try {
            defaultTransformer = defaultTransformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            defaultTextTransformer = defaultTransformerFactory.newTransformer();
            defaultTextTransformer.setOutputProperty("encoding", "UTF-8");
            defaultTextTransformer.setOutputProperty("indent", "yes");
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        defaultXPathFactory = XPathFactory.newInstance();
        defaultXPath = defaultXPathFactory.newXPath();
    }
}

