/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.security.MessageDigestUtil;

public class HttpURLConnectionUtil {
    public static Map<String, String> parseWwwAuthenticateHeader(String header) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String s : header.substring("Digest ".length()).split(",")) {
            String[] v = s.split("=");
            ret.put(v[0].trim(), StringUtil.dequote(v[1].trim()));
        }
        return ret;
    }

    public static String createDigestAuthValue(Map<String, String> wwwAuthElements, String method, String uri, String userName, String password, int nc) {
        String qop = wwwAuthElements.get("qop").split(",")[0];
        String ncs = String.format("%08d", nc);
        String cnonce = StringUtil.randomString(10);
        String response = MessageDigestUtil.digestByMD5(MessageDigestUtil.digestByMD5(userName + ":" + wwwAuthElements.get("realm") + ":" + password) + ":" + wwwAuthElements.get("nonce") + ":" + ncs + ":" + cnonce + ":" + qop + ":" + MessageDigestUtil.digestByMD5(method + ":" + uri));
        return String.format("Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", qop=%s, nc=%08d, cnonce=\"%s\", response=\"%s\", opaque=\"%s\"", userName, wwwAuthElements.get("realm"), wwwAuthElements.get("nonce"), uri, qop, 1, cnonce, response, wwwAuthElements.get("opaque"));
    }

    public static InputStream openResponseStream(HttpURLConnection con) throws IOException {
        String ce;
        InputStream is = null;
        try {
            is = con.getInputStream();
        }
        catch (IOException e) {
            is = con.getErrorStream();
        }
        if (is != null && (ce = con.getContentEncoding()) != null) {
            if (ce.equals("gzip")) {
                is = new GZIPInputStream(is);
            } else if (ce.equals("deflate")) {
                is = new DeflaterInputStream(is);
            }
        }
        return is;
    }

    public static OutputStream processWriteRequest(HttpURLConnection con, boolean compressContent, int compressThreashold, String compressAlgorithm, WriteProcess proc) throws IOException {
        if (compressContent) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            proc.write(baos);
            byte[] content = baos.toByteArray();
            if (content.length >= compressThreashold) {
                if (compressAlgorithm.equals("gzip")) {
                    con.addRequestProperty("Content-Encoding", "gzip");
                    OutputStream os = con.getOutputStream();
                    GZIPOutputStream gzos = new GZIPOutputStream(os);
                    gzos.write(content);
                    gzos.finish();
                    gzos.flush();
                    return os;
                }
                con.addRequestProperty("Content-Encoding", "deflate");
                OutputStream os = con.getOutputStream();
                DeflaterOutputStream dos = new DeflaterOutputStream(os);
                dos.write(content);
                dos.finish();
                dos.flush();
                return os;
            }
            OutputStream os = con.getOutputStream();
            os.write(content);
            return os;
        }
        OutputStream os = con.getOutputStream();
        proc.write(os);
        return os;
    }

    public static interface WriteProcess {
        public void write(OutputStream var1) throws IOException;
    }
}

