/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class URLUtil {
    public static URL replaceHost(URL url, String host) throws MalformedURLException {
        String protocol = url.getProtocol();
        int port = url.getPort();
        String file = url.getFile();
        return new URL(protocol, host, port, file);
    }

    public static URL replaceHostAndPort(URL url, String host, int port) throws MalformedURLException {
        String protocol = url.getProtocol();
        String file = url.getFile();
        return new URL(protocol, host, port, file);
    }

    public static URL dropUserInfo(URL url) {
        try {
            return new URL(String.format("%s://%s%s%s%s", url.getProtocol(), url.getHost(), url.getPort() != -1 ? ":" + url.getPort() : "", url.getFile(), url.getRef() != null ? "#" + url.getRef() : ""));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRootUrl(URL url) {
        return url.getProtocol() + "://" + url.getAuthority() + "/";
    }

    public static String getContextUrl(URL url) {
        String[] p = url.getPath().split("/");
        String c = p[0];
        if (c.length() == 0 && p.length > 1) {
            c = p[1];
        }
        return url.getProtocol() + "://" + url.getAuthority() + "/" + c + (c.length() > 0 ? "/" : "");
    }

    public static String getLocalUriString(String uri) {
        String[] p = uri.split("/", 3);
        return p[2];
    }

    public static String getUntilQuery(URL url) {
        return url.toString().split("\\?")[0];
    }

    public static Map<String, String> getQueryParameters(URL url) {
        HashMap<String, String> params = new HashMap<String, String>();
        String q = url.getQuery();
        if (q == null) {
            return params;
        }
        try {
            for (String p : q.split("&")) {
                String[] values = p.split("=", 2);
                if (values.length != 2) continue;
                params.put(URLDecoder.decode(values[0], "UTF-8"), URLDecoder.decode(values[1], "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return params;
    }

    public static URL addParam(URL url, String paramString) throws MalformedURLException {
        if (paramString == null) {
            return url;
        }
        String s = url.toString();
        int i = s.lastIndexOf("?");
        if (i == -1) {
            return new URL(url + "?" + paramString);
        }
        return new URL(url + "&" + paramString);
    }

    public static URL mergePath(URL url, String pathAndSearchPart) throws MalformedURLException {
        if (pathAndSearchPart == null) {
            return url;
        }
        String s = url.toString();
        int i = s.lastIndexOf("?");
        if (i == -1) {
            return new URL(URLUtil.concatPath(s, pathAndSearchPart));
        }
        String[] srcs = s.split("\\?", 2);
        String[] values = pathAndSearchPart.split("\\?", 2);
        StringBuilder b = new StringBuilder(URLUtil.concatPath(srcs[0], values[0]));
        if (srcs.length == 2) {
            if (b.indexOf("?") != -1) {
                b.append('&');
            } else {
                b.append('?');
            }
            b.append(srcs[1]);
        }
        if (values.length == 2) {
            if (b.indexOf("?") != -1) {
                b.append('&');
            } else {
                b.append('?');
            }
            b.append(values[1]);
        }
        return new URL(b.toString());
    }

    private static String concatPath(String src, String dst) {
        if (dst == null || dst.length() == 0) {
            return src;
        }
        int slash = dst.indexOf(47);
        int question = dst.indexOf(63);
        int equal = dst.indexOf(61);
        String sep = "";
        if (slash != 0 && question != 0) {
            sep = slash != -1 || question != -1 || equal == -1 ? "/" : "?";
        }
        return src + sep + dst;
    }
}

