/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import jp.go.nict.langrid.commons.lang.reflect.GenericsUtil;
import jp.go.nict.langrid.commons.lang.reflect.TypeUtil;
import jp.go.nict.langrid.commons.transformer.PassthroughTransformer;
import jp.go.nict.langrid.commons.transformer.StringToBooleanTransformer;
import jp.go.nict.langrid.commons.transformer.StringToDoubleTransformer;
import jp.go.nict.langrid.commons.transformer.StringToEnumTransformer;
import jp.go.nict.langrid.commons.transformer.StringToFloatTransformer;
import jp.go.nict.langrid.commons.transformer.StringToIntegerTransformer;
import jp.go.nict.langrid.commons.transformer.StringToLongTransformer;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class StringTransformerRepository {
    private Map<Class<?>, Transformer<String, ?>> transformers = new HashMap();
    private boolean autoAppendEnumTransformers;

    public StringTransformerRepository() {
        this.init();
    }

    public StringTransformerRepository(boolean autoAppendEnumTransformers) {
        this.autoAppendEnumTransformers = autoAppendEnumTransformers;
    }

    public synchronized <T> void add(Class<T> target, Transformer<String, T> transformer) {
        this.transformers.put(target, transformer);
    }

    public synchronized <T> void addTransformer(Transformer<String, T> transformer) {
        Type[] types = GenericsUtil.getActualTypeArgumentTypes(transformer.getClass(), Transformer.class);
        Class<?> target = TypeUtil.toClass(types[1]);
        this.add(target, transformer);
    }

    public synchronized <T> Transformer<String, T> find(Class<T> target) {
        Transformer<String, ?> ret = this.transformers.get(target);
        if (ret != null) {
            return ret;
        }
        if (target.isEnum()) {
            StringToEnumTransformer<T> t = new StringToEnumTransformer<T>(target);
            if (this.autoAppendEnumTransformers) {
                this.transformers.put(target, t);
            }
            return t;
        }
        return null;
    }

    private void init() {
        this.transformers.put(Boolean.TYPE, new StringToBooleanTransformer());
        this.transformers.put(Boolean.class, new StringToBooleanTransformer());
        this.transformers.put(Double.TYPE, new StringToDoubleTransformer());
        this.transformers.put(Double.class, new StringToDoubleTransformer());
        this.transformers.put(Float.TYPE, new StringToFloatTransformer());
        this.transformers.put(Float.class, new StringToFloatTransformer());
        this.transformers.put(Integer.TYPE, new StringToIntegerTransformer());
        this.transformers.put(Integer.class, new StringToIntegerTransformer());
        this.transformers.put(Long.TYPE, new StringToLongTransformer());
        this.transformers.put(Long.class, new StringToLongTransformer());
        this.transformers.put(String.class, new PassthroughTransformer());
    }
}

