/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

public class DuplicatingReader
extends FilterReader {
    private Writer writer;

    public DuplicatingReader(Reader source, Writer writer) {
        super(source);
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r != -1) {
            this.writer.write(r);
        }
        return r;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int r = this.in.read(cbuf);
        if (r != -1) {
            this.writer.write(cbuf, 0, r);
        }
        return r;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int r = this.in.read(cbuf, off, len);
        if (r != -1) {
            this.writer.write(cbuf, off, r);
        }
        return r;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int r = this.in.read(target);
        if (r != -1) {
            this.writer.write(target.array(), target.arrayOffset(), r);
        }
        return r;
    }
}

