/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.transformer.TransformerUtil;

public class FromToStringTransformer<U>
implements Transformer<Object, U> {
    private Constructor<U> strArgCtor;

    public FromToStringTransformer(Class<U> clazz) throws IllegalArgumentException {
        try {
            this.strArgCtor = clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public FromToStringTransformer(Constructor<U> strArgCtor) {
        if (!Arrays.equals(strArgCtor.getParameterTypes(), new Class[]{String.class})) {
            throw new IllegalArgumentException("strArgCtor must be constructor with String argument.");
        }
        this.strArgCtor = strArgCtor;
    }

    @Override
    public U transform(Object value) throws TransformationException {
        return TransformerUtil.fromString(this.strArgCtor, value.toString());
    }
}

