/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.go.nict.langrid.commons.transformer.TransformationException;

class TransformerUtil {
    TransformerUtil() {
    }

    static <T> T fromString(Constructor<T> ctor, String source) throws TransformationException {
        try {
            return ctor.newInstance(source);
        }
        catch (IllegalAccessException e) {
            throw new TransformationException(e);
        }
        catch (InstantiationException e) {
            throw new TransformationException(e);
        }
        catch (InvocationTargetException e) {
            throw new TransformationException(e);
        }
    }

    static Object convertWithStaticMethod(Method method, Object source) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(null, source);
        }
        catch (IllegalAccessException e) {
            throw new TransformationException(e);
        }
        catch (InvocationTargetException e) {
            throw new TransformationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new TransformationException(e);
        }
    }

    static <T> T convertWithStaticMethod(Method method, Object source, Class<T> type) {
        return (T)TransformerUtil.convertWithStaticMethod(method, source);
    }
}

