/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util.function;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jp.go.nict.langrid.commons.util.function.SoftenedException;

public class Functions {
    public static <T> Consumer<T> nullComsumer() {
        return new Consumer<T>(){

            @Override
            public void accept(T value) {
            }
        };
    }

    public static <T> Predicate<T> truePredicate() {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return true;
            }
        };
    }

    public static <E extends Throwable> Runnable soften(final RunnableWithException<E> r) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    throw new SoftenedException(e);
                }
            }
        };
    }

    public static <T, E extends Throwable> Supplier<T> soften(final SupplierWithException<T, E> s) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return s.get();
                }
                catch (Throwable e) {
                    throw new SoftenedException(e);
                }
            }
        };
    }

    public static <T, E extends Throwable> Consumer<T> soften(final ConsumerWithException<T, E> c) {
        return new Consumer<T>(){

            @Override
            public void accept(T value) {
                try {
                    c.accept(value);
                }
                catch (Throwable e) {
                    throw new SoftenedException(e);
                }
            }
        };
    }

    public static <T, U, E extends Throwable> BiConsumer<T, U> soften(final BiConsumerWithException<T, U, E> c) {
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T value1, U value2) {
                try {
                    c.accept(value1, value2);
                }
                catch (Throwable e) {
                    throw new SoftenedException(e);
                }
            }
        };
    }

    public static <T, R, E extends Throwable> Function<T, R> soften(final FunctionWithException<T, R, E> f) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                try {
                    return f.apply(value);
                }
                catch (Throwable e) {
                    throw new SoftenedException(e);
                }
            }
        };
    }

    public static <T, U, R, E extends Throwable> BiFunction<T, U, R> soften(final BiFunctionWithException<T, U, R, E> f) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                try {
                    return f.apply(value1, value2);
                }
                catch (Throwable e) {
                    throw new SoftenedException(e);
                }
            }
        };
    }

    public static <E extends Throwable> void unsoft(SoftenedException e) throws E {
        Throwable t = e.getCause();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw t;
    }

    public static <P, E extends Throwable> void tunnelingExecute(Consumer<Consumer<P>> term, ConsumerWithException<P, E> process) throws E {
        try {
            term.accept(Functions.soften((T pr) -> process.accept(pr)));
        }
        catch (SoftenedException e) {
            throw e.getCause();
        }
    }

    public static interface BiFunctionWithException<T, U, R, E extends Throwable> {
        public R apply(T var1, U var2) throws E;
    }

    public static interface FunctionWithException<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    public static interface BiConsumerWithException<T, U, E extends Throwable> {
        public void accept(T var1, U var2) throws E;
    }

    public static interface ConsumerWithException<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    public static interface SupplierWithException<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface RunnableWithException<E extends Throwable> {
        public void run() throws E;
    }
}

