/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.MimeHeaders;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.ws.BasicAuthUtil;
import jp.go.nict.langrid.commons.ws.FilePersistentProperties;
import jp.go.nict.langrid.commons.ws.HttpServletRequestUtil;
import jp.go.nict.langrid.commons.ws.ServiceContext;

public class ServletServiceContext
extends ServiceContext {
    private HttpServletRequest request;
    private Iterable<RpcHeader> requestRpcHeaders = new ArrayList<RpcHeader>();
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private FilePersistentProperties props;
    private String authorizedUserGridId;
    private String authorizedUserId;
    private String authorizedPassword;

    public ServletServiceContext(ServletConfig config, HttpServletRequest request, Iterable<RpcHeader> requestRpcHeaders) {
        this(request, requestRpcHeaders);
        this.servletConfig = config;
    }

    public ServletServiceContext(HttpServletRequest request, Iterable<RpcHeader> requestRpcHeaders) {
        this.request = request;
        this.requestRpcHeaders = requestRpcHeaders;
        this.servletContext = request.getSession().getServletContext();
        String user = request.getRemoteUser();
        if (user != null) {
            this.authorizedUserId = user;
        }
    }

    public ServletServiceContext(HttpServletRequest request) {
        this.request = request;
        this.requestRpcHeaders = new ArrayList<RpcHeader>();
        this.servletContext = request.getSession().getServletContext();
        String user = request.getRemoteUser();
        if (user != null) {
            this.authorizedUserId = user;
        }
    }

    @Override
    public URL getRequestUrl() {
        return HttpServletRequestUtil.getRequestUrl(this.getRequest());
    }

    @Override
    public MimeHeaders getRequestMimeHeaders() {
        MimeHeaders headers = new MimeHeaders();
        HttpServletRequest req = this.getRequest();
        Enumeration en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            headers.addHeader(name, req.getHeader(name));
        }
        return headers;
    }

    @Override
    public Iterable<RpcHeader> getRequestRpcHeaders() {
        return this.requestRpcHeaders;
    }

    @Override
    public String getAuthUserGridId() {
        return this.authorizedUserGridId;
    }

    @Override
    public String getAuthUser() {
        return this.authorizedUserId;
    }

    @Override
    public String getAuthPass() {
        if (this.authorizedPassword == null && this.authorizedUserId != null) {
            this.authorizedPassword = this.getBasicAuthUserAndPassword().getSecond();
        }
        return this.authorizedPassword;
    }

    @Override
    public String getRemoteAddress() {
        return this.request.getRemoteAddr();
    }

    @Override
    public String getInitParameter(String param) {
        String v;
        if (this.servletConfig != null && (v = this.servletConfig.getInitParameter(param)) != null) {
            return v;
        }
        ServletContext c = this.getServletContext();
        if (c == null) {
            return null;
        }
        return c.getInitParameter(param);
    }

    @Override
    public String getPersistentProperty(String name) {
        this.prepareProperties();
        return this.props.getProperty(name);
    }

    @Override
    public void setPersistentProperty(String name, String value) {
        this.prepareProperties();
        this.props.setProperty(name, value);
    }

    @Override
    public String getRealPath(String path) {
        String ret = this.getServletContext().getRealPath(path);
        if (ret == null && !path.startsWith("/")) {
            ret = this.getServletContext().getRealPath("/" + path);
        }
        return ret;
    }

    public Pair<String, String> getBasicAuthUserAndPassword() {
        String header = this.getRequest().getHeader("Authorization");
        if (header == null) {
            return null;
        }
        Pair<String, String> userAndPass = BasicAuthUtil.decode(header);
        if (userAndPass == null) {
            return null;
        }
        return userAndPass;
    }

    public void setAuthorized(String gridId, String userId, String password) {
        this.authorizedUserGridId = gridId;
        this.authorizedUserId = userId;
        this.authorizedPassword = password;
    }

    private ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    private synchronized void prepareProperties() {
        if (this.props != null) {
            return;
        }
        this.props = new FilePersistentProperties(new File(this.getRealPath("WEB-INF/node.properties")));
    }
}

