/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.beanutils;

import java.lang.reflect.Array;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class ArrayToArrayTransformer<T, U>
implements Transformer<T, U> {
    private Converter converter;
    private Class<?> targetClass;

    public ArrayToArrayTransformer(Converter converter, Class<U> targetClass) {
        this.converter = converter;
        if (!targetClass.isArray()) {
            throw new IllegalArgumentException("targetClass must be an array class");
        }
        this.targetClass = targetClass.getComponentType();
    }

    @Override
    public U transform(T value) throws TransformationException {
        if (value == null) {
            return null;
        }
        return this.transformArray(value, this.targetClass);
    }

    private U transformArray(Object array, Class<?> targetClass) {
        int n = Array.getLength(array);
        Object ret = Array.newInstance(targetClass, n);
        for (int i = 0; i < n; ++i) {
            Array.set(ret, i, this.converter.convert(Array.get(array, i), targetClass));
        }
        return (U)ret;
    }
}

